/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.map.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.persistence.api.PersistentSession;
import org.drools.persistence.api.PersistentWorkItem;
import org.jbpm.persistence.ProcessStorage;
import org.jbpm.persistence.ProcessStorageEnvironmentBuilder;
import org.jbpm.persistence.api.PersistentProcessInstance;
import org.jbpm.persistence.map.impl.MapPersistenceTest;
import org.jbpm.persistence.processinstance.ProcessInstanceInfo;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.runtime.Environment;
import org.kie.internal.persistence.jpa.JPAKnowledgeService;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class MapBasedPersistenceTest
extends MapPersistenceTest {
    private SimpleProcessStorage storage;

    @Before
    public void createStorage() {
        this.storage = new SimpleProcessStorage();
    }

    @Override
    protected StatefulKnowledgeSession createSession(KieBase kbase) {
        ProcessStorageEnvironmentBuilder envBuilder = new ProcessStorageEnvironmentBuilder((ProcessStorage)this.storage);
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.api.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.newStatefulKnowledgeSession((KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected StatefulKnowledgeSession disposeAndReloadSession(StatefulKnowledgeSession ksession, long ksessionId, KieBase kbase) {
        ksession.dispose();
        ProcessStorageEnvironmentBuilder envBuilder = new ProcessStorageEnvironmentBuilder((ProcessStorage)this.storage);
        Environment env = KieServices.get().newEnvironment();
        env.set("org.kie.transaction.TransactionManager", (Object)envBuilder.getTransactionManager());
        env.set("org.kie.api.persistence.PersistenceContextManager", (Object)envBuilder.getPersistenceContextManager());
        return JPAKnowledgeService.loadStatefulKnowledgeSession((Long)ksessionId, (KieBase)kbase, null, (Environment)env);
    }

    @Override
    protected int getProcessInstancesCount() {
        return this.storage.processes.size();
    }

    @Override
    protected int getKnowledgeSessionsCount() {
        return this.storage.ksessions.size();
    }

    private static class SimpleProcessStorage
    implements ProcessStorage {
        private Map<Long, PersistentSession> ksessions = new HashMap<Long, PersistentSession>();
        private Map<Long, PersistentProcessInstance> processes = new HashMap<Long, PersistentProcessInstance>();
        private Map<Long, PersistentWorkItem> workItems = new HashMap<Long, PersistentWorkItem>();

        private SimpleProcessStorage() {
        }

        public void saveOrUpdate(PersistentSession ksessionInfo) {
            ksessionInfo.transform();
            this.ksessions.put(ksessionInfo.getId(), ksessionInfo);
        }

        public PersistentSession findSessionInfo(Long id) {
            return this.ksessions.get(id);
        }

        public PersistentProcessInstance findProcessInstanceInfo(Long processInstanceId) {
            PersistentProcessInstance processInstanceInfo = this.processes.get(processInstanceId);
            if (processInstanceInfo != null) {
                ((ProcessInstanceInfo)processInstanceInfo).clearProcessInstance();
            }
            return processInstanceInfo;
        }

        public void saveOrUpdate(PersistentProcessInstance processInstanceInfo) {
            processInstanceInfo.transform();
            this.processes.put(processInstanceInfo.getId(), processInstanceInfo);
        }

        public long getNextProcessInstanceId() {
            return this.processes.size() + 1;
        }

        public void removeProcessInstanceInfo(Long id) {
            this.processes.remove(id);
        }

        public List<Long> getProcessInstancesWaitingForEvent(String type) {
            ArrayList<Long> processInstancesWaitingForEvent = new ArrayList<Long>();
            for (PersistentProcessInstance processInstanceInfo : this.processes.values()) {
                if (!((ProcessInstanceInfo)processInstanceInfo).getEventTypes().contains(type)) continue;
                processInstancesWaitingForEvent.add(processInstanceInfo.getId());
            }
            return processInstancesWaitingForEvent;
        }

        public void saveOrUpdate(PersistentWorkItem workItem) {
            this.workItems.put(workItem.getId(), workItem);
        }

        public Long getNextWorkItemId() {
            return new Long(this.workItems.size() + 1);
        }

        public PersistentWorkItem findWorkItemInfo(Long id) {
            return this.workItems.get(id);
        }

        public void remove(PersistentWorkItem workItem) {
            this.workItems.remove(workItem.getId());
        }

        public Long getNextStatefulKnowledgeSessionId() {
            return new Long(this.ksessions.size() + 1);
        }

        public void lock(PersistentSession session) {
            throw new UnsupportedOperationException("Map based persistence does not support locking.");
        }

        public void lock(PersistentWorkItem workItem) {
            throw new UnsupportedOperationException("Map based persistence does not support locking.");
        }
    }
}

