/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.data;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jbpm.query.jpa.data.QueryCriteria;

public class QueryCriteriaUtil {
    public static boolean noLimitingCriteria(List<QueryCriteria> criteriaList) {
        QueryCriteria criteria = criteriaList.get(0);
        for (int i = 0; i < criteriaList.size(); ++i) {
            criteria = criteriaList.get(i);
            if (criteria.isUnion().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static List<QueryCriteria> getLimitingCriteria(List<QueryCriteria> criteriaList) {
        LinkedList<QueryCriteria> allLimitingCriteria = new LinkedList<QueryCriteria>();
        for (QueryCriteria criteria : criteriaList) {
            if (criteria.isUnion().booleanValue()) continue;
            allLimitingCriteria.add(criteria);
            if (criteria.getCriteria().isEmpty()) continue;
            allLimitingCriteria.addAll(QueryCriteriaUtil.getSubQueryLimitingCriteria(criteria.getCriteria()));
        }
        return allLimitingCriteria;
    }

    private static List<QueryCriteria> getSubQueryLimitingCriteria(List<QueryCriteria> criteriaList) {
        LinkedList<QueryCriteria> limitingCriteria = new LinkedList<QueryCriteria>();
        QueryCriteriaUtil.sortCriteriaUnionFirst(criteriaList);
        for (QueryCriteria criteria : criteriaList) {
            if (criteria.isUnion().booleanValue()) {
                return Collections.EMPTY_LIST;
            }
            limitingCriteria.add(criteria);
        }
        return limitingCriteria;
    }

    public static QueryCriteria removeLimitingCriteria(String listId, List<QueryCriteria> criteriaList) {
        Iterator<QueryCriteria> iter = criteriaList.iterator();
        while (iter.hasNext()) {
            QueryCriteria criteria = iter.next();
            if (criteria.isUnion().booleanValue()) continue;
            if (listId.equals(criteria.getListId())) {
                iter.remove();
                return criteria;
            }
            if (criteria.getCriteria().size() <= 0) continue;
            return QueryCriteriaUtil.removeSubQueryLimitingCriteria(listId, criteria.getCriteria());
        }
        return null;
    }

    private static QueryCriteria removeSubQueryLimitingCriteria(String listId, List<QueryCriteria> criteriaList) {
        Iterator<QueryCriteria> iter = criteriaList.iterator();
        QueryCriteriaUtil.sortCriteriaUnionFirst(criteriaList);
        while (iter.hasNext()) {
            QueryCriteria criteria = iter.next();
            if (criteria.isUnion().booleanValue()) {
                return null;
            }
            if (listId.equals(criteria.getListId())) {
                iter.remove();
                return criteria;
            }
            if (criteria.getCriteria().size() <= 0) continue;
            return QueryCriteriaUtil.removeSubQueryLimitingCriteria(listId, criteria.getCriteria());
        }
        return null;
    }

    private static void sortCriteriaUnionFirst(List<QueryCriteria> criteriaList) {
        Collections.sort(criteriaList, new Comparator<QueryCriteria>(){

            @Override
            public int compare(QueryCriteria o1, QueryCriteria o2) {
                if (o1.isUnion().booleanValue() && !o2.isUnion().booleanValue()) {
                    return 1;
                }
                if (o2.isUnion().booleanValue() && !o1.isUnion().booleanValue()) {
                    return -1;
                }
                return 0;
            }
        });
    }
}

