/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.data;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.jbpm.query.jpa.data.QueryCriteria;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(value={"union", "type", "currentGroupCriteria", "currentGroupParents", "like", "range"})
public class QueryWhere {
    @JsonIgnore
    private transient boolean union = true;
    @JsonIgnore
    private transient ParameterType type = ParameterType.NORMAL;
    @XmlElement(name="queryCriteria")
    private List<QueryCriteria> criteria = new LinkedList<QueryCriteria>();
    @JsonIgnore
    private transient List<QueryCriteria> currentGroupCriteria = this.criteria;
    @JsonIgnore
    private transient Stack<Object> currentGroupParents = new Stack();

    public QueryWhere() {
    }

    public <T> QueryCriteria addAppropriateParam(String listId, T ... param) {
        if (param.length == 0) {
            return null;
        }
        if (ParameterType.REGEXP.equals((Object)this.type) && !(param[0] instanceof String)) {
            throw new IllegalArgumentException("Only String parameters may be used in regular expressions.");
        }
        QueryCriteria criteria = this.getAppropriateQueryCriteria(listId, param.length);
        for (T paramElem : param) {
            criteria.addParameter(paramElem);
        }
        this.addCriteria(criteria);
        return criteria;
    }

    public <T> void addRangeParameter(String listId, T param, boolean start) {
        ParameterType origType = this.type;
        this.type = ParameterType.RANGE;
        QueryCriteria criteria = this.getAppropriateQueryCriteria(listId, 2);
        int index = start ? 0 : 1;
        criteria.setParameter(index, param);
        this.addCriteria(criteria);
        this.type = origType;
    }

    private void addCriteria(QueryCriteria criteria) {
        this.currentGroupCriteria.add(criteria);
    }

    private QueryCriteria getAppropriateQueryCriteria(String listId, int valueListSize) {
        QueryCriteria criteria = new QueryCriteria(listId, this.union, this.type, valueListSize);
        this.resetGroup();
        return criteria;
    }

    public void startGroup() {
        QueryCriteria newCriteriaGroupParent;
        if (this.currentGroupCriteria.isEmpty()) {
            newCriteriaGroupParent = new QueryCriteria();
            this.currentGroupCriteria.add(newCriteriaGroupParent);
        } else {
            newCriteriaGroupParent = this.currentGroupCriteria.get(this.currentGroupCriteria.size() - 1);
        }
        this.currentGroupParents.push(newCriteriaGroupParent);
        this.currentGroupCriteria = newCriteriaGroupParent.getCriteria();
    }

    public void endGroup() {
        if (this.currentGroupParents.isEmpty()) {
            throw new IllegalStateException("Can not end group: no group has been started!");
        }
        this.currentGroupParents.pop();
        Object newCriteriaGroupParent = this.currentGroupParents.peek();
        this.currentGroupCriteria = newCriteriaGroupParent instanceof QueryWhere ? ((QueryWhere)newCriteriaGroupParent).getCriteria() : ((QueryCriteria)newCriteriaGroupParent).getCriteria();
    }

    private void resetGroup() {
        this.currentGroupParents.clear();
    }

    public List<QueryCriteria> getCriteria() {
        return this.criteria;
    }

    public void setParameters(List<QueryCriteria> parameters) {
        this.criteria = parameters;
    }

    public void setToUnion() {
        this.union = true;
    }

    public void setToIntersection() {
        this.union = false;
    }

    public boolean isUnion() {
        return this.union;
    }

    public void setToLike() {
        this.type = ParameterType.REGEXP;
    }

    public boolean isLike() {
        return this.type.equals((Object)ParameterType.REGEXP);
    }

    public void setToNormal() {
        this.type = ParameterType.NORMAL;
    }

    public void setToRange() {
        this.type = ParameterType.RANGE;
    }

    public boolean isRange() {
        return this.type.equals((Object)ParameterType.RANGE);
    }

    public void clear() {
        this.union = true;
        this.type = ParameterType.NORMAL;
        this.resetGroup();
        if (this.criteria != null) {
            this.criteria.clear();
        }
    }

    public QueryWhere(QueryWhere queryParameters) {
        this.union = queryParameters.union;
        this.type = queryParameters.type;
        if (queryParameters.criteria != null) {
            this.criteria = new LinkedList<QueryCriteria>(queryParameters.criteria);
        }
    }

    @XmlEnum
    public static enum ParameterType {
        NORMAL,
        REGEXP,
        RANGE;

    }
}

