/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.data;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.jbpm.query.jpa.data.AbstractQuerySerializationTest;

public class JaxbQuerySerializationTest
extends AbstractQuerySerializationTest {
    Set<Class> extraClasses = new HashSet<Class>();

    @Override
    public <T> T testRoundTrip(T input) throws Exception {
        String xmlStr = this.convertJaxbObjectToString(input);
        logger.debug(xmlStr);
        return (T)this.convertStringToJaxbObject(xmlStr, input.getClass());
    }

    public String convertJaxbObjectToString(Object object) throws JAXBException {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(object.getClass());
        classes.addAll(this.extraClasses);
        Marshaller marshaller = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()])).createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter stringWriter = new StringWriter();
        marshaller.marshal(object, (Writer)stringWriter);
        String output = stringWriter.toString();
        return output;
    }

    public Object convertStringToJaxbObject(String xmlStr, Class clazz) throws JAXBException {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(clazz);
        classes.addAll(this.extraClasses);
        Unmarshaller unmarshaller = JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()])).createUnmarshaller();
        ByteArrayInputStream xmlStrInputStream = new ByteArrayInputStream(xmlStr.getBytes());
        Object jaxbObj = unmarshaller.unmarshal((InputStream)xmlStrInputStream);
        return jaxbObj;
    }

    @Override
    void addSerializableClass(Class objClass) {
        this.extraClasses.add(objClass);
    }
}

