/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query.jpa.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.kie.internal.query.QueryParameterIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryAndParameterAppender {
    private static Logger logger = LoggerFactory.getLogger(QueryAndParameterAppender.class);
    private boolean noWhereClauseYet = true;
    private boolean noClauseAddedYet = true;
    private int nestedParentheses = 0;
    private boolean alreadyUsed = false;
    private final StringBuilder queryBuilder;
    private final Map<String, Object> queryParams;
    private int queryParamId = 0;

    public QueryAndParameterAppender(StringBuilder queryBuilder, Map<String, Object> params) {
        this.queryBuilder = queryBuilder;
        this.queryParams = params;
        this.noWhereClauseYet = !queryBuilder.toString().contains("WHERE");
    }

    public boolean hasBeenUsed() {
        return !this.noClauseAddedYet;
    }

    public void markAsUsed() {
        this.noClauseAddedYet = false;
    }

    public void addNamedQueryParam(String name, Object value) {
        this.queryParams.put(name, value);
    }

    public void openParentheses() {
        ++this.nestedParentheses;
        this.queryBuilder.append(" ( ");
    }

    public void closeParentheses() {
        this.queryBuilder.append(" ) ");
        --this.nestedParentheses;
    }

    public int getParenthesesNesting() {
        return this.nestedParentheses;
    }

    public <T> void addQueryParameters(List<? extends Object> paramList, String listId, Class<T> type, String fieldName, String joinClause, boolean union) {
        if (paramList == null || paramList.size() <= 0) {
            return;
        }
        Object inputObject = paramList.get(0);
        List<T> listIdParams = this.checkAndConvertListToType(paramList, inputObject, listId, type);
        String paramName = this.generateParamName();
        StringBuilder queryClause = new StringBuilder("( " + fieldName + " IN (:" + paramName + ")");
        if (joinClause != null) {
            queryClause.append(" AND " + joinClause);
        }
        queryClause.append(" )");
        this.addToQueryBuilder(queryClause.toString(), union, paramName, listIdParams);
    }

    public <T> void addQueryParameters(Map<String, List<? extends Object>> inputParamsMap, String listId, Class<T> type, String fieldName, boolean union, String joinClause) {
        List<? extends Object> inputParams = inputParamsMap.get(listId);
        this.addQueryParameters(inputParams, listId, type, fieldName, joinClause, union);
    }

    public <T> void addQueryParameters(List<? extends Object> inputParams, String listId, Class<T> type, String fieldName, boolean union) {
        this.addQueryParameters(inputParams, listId, type, fieldName, null, union);
    }

    public <T> void addQueryParameters(Map<String, List<? extends Object>> inputParamsMap, String listId, Class<T> type, String fieldName, boolean union) {
        List<? extends Object> inputParams = inputParamsMap.get(listId);
        this.addQueryParameters(inputParams, listId, type, fieldName, null, union);
    }

    public <T> void addRangeQueryParameters(List<? extends Object> paramList, String listId, Class<T> type, String fieldName, String joinClause, boolean union) {
        String minParamName;
        Object inputObject;
        if (paramList != null && paramList.size() > 0) {
            inputObject = paramList.get(0);
            if (inputObject == null && (inputObject = paramList.get(1)) == null) {
                return;
            }
        } else {
            return;
        }
        List<T> listIdParams = this.checkAndConvertListToType(paramList, inputObject, listId, type);
        T min = listIdParams.get(0);
        T max = listIdParams.get(1);
        HashMap<String, T> paramNameMinMaxMap = new HashMap<String, T>(2);
        StringBuilder queryClause = new StringBuilder("( ");
        if (joinClause != null) {
            queryClause.append("( ");
        }
        queryClause.append(fieldName);
        if (min == null) {
            if (max == null) {
                return;
            }
            String maxParamName = this.generateParamName();
            queryClause.append(" <= :" + maxParamName + " ");
            paramNameMinMaxMap.put(maxParamName, max);
        } else if (max == null) {
            minParamName = this.generateParamName();
            queryClause.append(" >= :" + minParamName + " ");
            paramNameMinMaxMap.put(minParamName, min);
        } else {
            minParamName = this.generateParamName();
            String maxParamName = this.generateParamName();
            if (union) {
                queryClause.append(" >= :" + minParamName + " OR " + fieldName + " <= :" + maxParamName + " ");
            } else {
                queryClause.append(" BETWEEN :" + minParamName + " AND :" + maxParamName + " ");
            }
            paramNameMinMaxMap.put(minParamName, min);
            paramNameMinMaxMap.put(maxParamName, max);
        }
        if (joinClause != null) {
            queryClause.append(") and " + joinClause.trim() + " ");
        }
        queryClause.append(")");
        this.internalAddToQueryBuilder(queryClause.toString(), union);
        for (Map.Entry nameMinMaxEntry : paramNameMinMaxMap.entrySet()) {
            this.addNamedQueryParam((String)nameMinMaxEntry.getKey(), nameMinMaxEntry.getValue());
        }
        this.queryBuilderModificationCleanup();
    }

    public <T> void addRangeQueryParameters(Map<String, List<? extends Object>> inputParamsMap, String listId, Class<T> type, String fieldName, boolean union, String joinClause) {
        List<? extends Object> inputParams = inputParamsMap.get(listId);
        this.addRangeQueryParameters(inputParams, listId, type, fieldName, joinClause, union);
    }

    public <T> void addRangeQueryParameters(List<? extends Object> inputParams, String listId, Class<T> type, String fieldName, boolean union) {
        this.addRangeQueryParameters(inputParams, listId, type, fieldName, null, union);
    }

    public <T> void addRangeQueryParameters(Map<String, List<? extends Object>> inputParamsMap, String listId, Class<T> type, String fieldName, boolean union) {
        List<? extends Object> inputParams = inputParamsMap.get(listId);
        this.addRangeQueryParameters(inputParams, listId, type, fieldName, null, union);
    }

    public void addRegexQueryParameters(List<String> inputParams, String listId, String fieldName, boolean union) {
        this.addRegexQueryParameters(inputParams, listId, fieldName, null, union);
    }

    public void addRegexQueryParameters(List<String> paramValList, String listId, String fieldName, String joinClause, boolean union) {
        if (paramValList == null || paramValList.isEmpty()) {
            return;
        }
        ArrayList<String> regexList = new ArrayList<String>(paramValList.size());
        for (String input : paramValList) {
            if (input == null || input.isEmpty()) continue;
            String regex = input.replace('*', '%').replace('.', '_');
            regexList.add(regex);
        }
        HashMap paramNameRegexMap = new HashMap();
        StringBuilder queryClause = new StringBuilder("( ");
        if (joinClause != null) {
            queryClause.append("( ");
        }
        for (int i = 0; i < regexList.size(); ++i) {
            String paramName = this.generateParamName();
            queryClause.append(fieldName + " LIKE :" + paramName + " ");
            paramNameRegexMap.put(paramName, regexList.get(i));
            if (i + 1 >= regexList.size()) continue;
            queryClause.append(union ? "OR" : "AND").append(" ");
        }
        if (joinClause != null) {
            queryClause.append(") AND " + joinClause.trim() + " ");
        }
        queryClause.append(")");
        this.internalAddToQueryBuilder(queryClause.toString(), union);
        for (Map.Entry nameRegexEntry : paramNameRegexMap.entrySet()) {
            this.addNamedQueryParam((String)nameRegexEntry.getKey(), nameRegexEntry.getValue());
        }
        this.queryBuilderModificationCleanup();
    }

    public void addToQueryBuilder(String query, boolean union) {
        this.internalAddToQueryBuilder(query, union);
        this.queryBuilderModificationCleanup();
    }

    public <T> void addToQueryBuilder(String query, boolean union, String paramName, List<T> paramValList) {
        this.internalAddToQueryBuilder(query, union);
        HashSet<T> paramVals = new HashSet<T>(paramValList);
        this.addNamedQueryParam(paramName, paramVals);
        this.queryBuilderModificationCleanup();
    }

    private void internalAddToQueryBuilder(String query, boolean union) {
        if (this.noClauseAddedYet) {
            if (this.noWhereClauseYet) {
                this.queryBuilder.append(" WHERE ");
            } else {
                this.queryBuilder.append(" AND ");
            }
            this.noClauseAddedYet = false;
        } else if (this.alreadyUsed) {
            this.queryBuilder.append(union ? "\nOR " : "\nAND ");
        }
        this.queryBuilder.append(query);
    }

    public void queryBuilderModificationCleanup() {
        this.alreadyUsed = true;
    }

    public boolean whereClausePresent() {
        return !this.noWhereClauseYet;
    }

    private <T> List<T> checkAndConvertListToType(List<?> inputList, Object inputObject, String listId, Class<T> type) {
        if (logger.isDebugEnabled()) {
            QueryAndParameterAppender.debugQueryParametersIdentifiers();
        }
        assert (type != null) : listId + ": type is null!";
        assert (inputObject != null) : listId + ": input object is null!";
        if (type.equals(inputObject.getClass())) {
            return inputList;
        }
        throw new IllegalArgumentException(listId + " parameter is an instance of List<" + inputObject.getClass().getSimpleName() + "> instead of List<" + type.getSimpleName() + ">");
    }

    public String generateParamName() {
        int id = this.queryParamId++ % 26;
        char first = (char)(65 + id);
        return new String(first + String.valueOf((id + 1) / 26 + 1));
    }

    public StringBuilder getQueryBuilder() {
        return this.queryBuilder;
    }

    public static void debugQueryParametersIdentifiers() {
        try {
            Field[] fields = QueryParameterIdentifiers.class.getDeclaredFields();
            TreeMap<String, String> fieldValueMap = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int int1 = -1;
                    try {
                        int1 = Integer.parseInt(o1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int int2 = -1;
                    try {
                        int2 = Integer.parseInt(o2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (int1 > -1 && int2 > -1) {
                        return new Integer(int1).compareTo(int2);
                    }
                    if (int1 > -1 && int2 == -1) {
                        return -1;
                    }
                    if (int1 == -1 && int2 > -1) {
                        return 1;
                    }
                    return o1.compareTo(o2);
                }
            });
            for (Field field : fields) {
                fieldValueMap.put(field.get(null).toString(), field.getName());
            }
            for (Map.Entry entry : fieldValueMap.entrySet()) {
                logger.debug(String.format("%-12s : %s", entry.getKey(), entry.getValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

