/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.query;

import ch.qos.logback.classic.Level;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.persistence.EntityManagerFactory;
import org.jbpm.test.persistence.util.PersistenceUtil;
import org.junit.Assert;
import org.kie.internal.query.ExtendedParametrizedQueryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryBuilderCoverageTestUtil {
    private static HashMap<String, Object> context;
    private static EntityManagerFactory emf;
    private static final Logger logger;

    public static EntityManagerFactory beforeClass(String persistenceUnit) {
        QueryBuilderCoverageTestUtil.hackTheDatabaseMetadataLoggerBecauseTheresALogbackXmlInTheClasspath();
        context = PersistenceUtil.setupWithPoolingDataSource((String)persistenceUnit);
        emf = (EntityManagerFactory)context.get("org.kie.api.persistence.jpa.EntityManagerFactory");
        return emf;
    }

    public static void afterClass() {
        PersistenceUtil.cleanUp(context);
    }

    public static void hackTheDatabaseMetadataLoggerBecauseTheresALogbackXmlInTheClasspath() {
        String[] fieldName = new String[]{"LOG", "log", "logger"};
        try {
            Object loggerObj = null;
            for (int i = 0; i < fieldName.length; ++i) {
                Class objClass = null;
                objClass = loggerObj == null ? DatabaseMetaData.class : loggerObj.getClass();
                Field loggerField = objClass.getDeclaredField(fieldName[i]);
                loggerField.setAccessible(true);
                loggerObj = loggerField.get(loggerObj);
            }
            ((ch.qos.logback.classic.Logger)loggerObj).setLevel(Level.OFF);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void queryBuilderCoverageTest(ExtendedParametrizedQueryBuilder queryBuilder, Class builderClass, ModuleSpecificInputFiller inputFiller, String ... skipMethodName) {
        HashSet<Method> queryMethodSet = new HashSet<Method>();
        while (builderClass != null && !builderClass.equals(ExtendedParametrizedQueryBuilder.class)) {
            queryMethodSet.addAll(Arrays.asList(builderClass.getMethods()));
            builderClass = builderClass.getInterfaces()[0];
        }
        ArrayList queryMethods = new ArrayList(queryMethodSet);
        String[] specialMethodsArr = new String[]{"newGroup", "endGroup", "equals", "identity", "intersect", "union", "and", "or", "like", "regex", "equal", "build", "clear", "notify", "notifyAll", "wait"};
        HashSet<String> specialMethods = new HashSet<String>(Arrays.asList(specialMethodsArr));
        specialMethods.addAll(Arrays.asList(skipMethodName));
        Iterator iter = queryMethods.iterator();
        while (iter.hasNext()) {
            Method method = (Method)iter.next();
            if (!specialMethods.contains(method.getName())) continue;
            iter.remove();
        }
        Collections.sort(queryMethods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                if (m1 == m2) {
                    return 0;
                }
                if (m1 == null) {
                    return -1;
                }
                if (m2 == null) {
                    return 1;
                }
                return m1.getName().compareTo(m2.getName());
            }
        });
        for (Method methodA : queryMethods) {
            for (Method methodB : queryMethods) {
                Object[] inputA = QueryBuilderCoverageTestUtil.fillInput(methodA.getParameterTypes(), inputFiller);
                Object[] inputB = QueryBuilderCoverageTestUtil.fillInput(methodB.getParameterTypes(), inputFiller);
                try {
                    StringBuffer testName = new StringBuffer(methodA.getName());
                    QueryBuilderCoverageTestUtil.callMethod(methodA, queryBuilder, inputA);
                    testName.append(" | ");
                    queryBuilder.union();
                    testName.append(methodB.getName());
                    QueryBuilderCoverageTestUtil.callMethod(methodB, queryBuilder, inputB);
                    logger.debug(testName.toString());
                    queryBuilder.build().getResultList();
                    queryBuilder.clear();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    String msg = QueryBuilderCoverageTestUtil.createTestName(methodA, inputA, methodB, inputB, queryBuilder.getClass());
                    Assert.fail((String)msg);
                }
            }
        }
    }

    private static <T, S> String createTestName(Method methodA, T[] inputA, Method methodB, S[] inputB, Class builderClass) {
        StringBuffer msg = new StringBuffer(QueryBuilderCoverageTestUtil.getMethodName(methodA, inputA));
        msg.append(" OR ");
        msg.append(QueryBuilderCoverageTestUtil.getMethodName(methodB, inputB));
        msg.append(": " + builderClass.getSimpleName());
        return msg.toString();
    }

    private static void callMethod(Method method, Object obj, Object input) {
        boolean noArgs = false;
        Object[] arrInput = null;
        if (input.getClass().isArray()) {
            int length = Array.getLength(input);
            if (length == 1) {
                input = Array.get(input, 0);
            } else if (length == 0) {
                noArgs = true;
            } else {
                arrInput = (Object[])input;
            }
        }
        try {
            if (noArgs) {
                method.invoke(obj, new Object[0]);
            } else if (arrInput != null) {
                method.invoke(obj, arrInput);
            } else {
                method.invoke(obj, input);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Method [" + method.getName() + ".(" + QueryBuilderCoverageTestUtil.getInputAsString(input) + ")]"));
        }
    }

    private static <T> String getMethodName(Method method, T[] input) {
        StringBuilder msg = new StringBuilder(method.getName());
        msg.append("(");
        if (input.length > 0) {
            msg.append(QueryBuilderCoverageTestUtil.getInputAsString(input[0]));
            for (int j = 1; j < input.length; ++j) {
                msg.append(",").append(QueryBuilderCoverageTestUtil.getInputAsString(input[j]));
            }
        }
        msg.append(")");
        return msg.toString();
    }

    private static <T> String getInputAsString(Object input) {
        if (input.getClass().isArray()) {
            if (Array.getLength(input) == 0) {
                return "";
            }
            Class<?> compType = input.getClass().getComponentType();
            if (Integer.TYPE.equals(compType)) {
                return Arrays.toString((int[])input);
            }
            if (Long.TYPE.equals(compType)) {
                return Arrays.toString((long[])input);
            }
            return Arrays.toString((Object[])input);
        }
        return input.toString();
    }

    private static Object[] fillInput(Type[] types, ModuleSpecificInputFiller inputFiller) {
        Object[] result = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Class type = (Class)types[i];
            if (type.equals(Integer.TYPE)) {
                result[i] = 23;
            } else if (type.equals(Boolean.TYPE)) {
                result[i] = false;
            } else if (type.equals(Date.class)) {
                result[i] = new Date();
            } else if (type.equals(Long.TYPE)) {
                result[i] = 46L;
            } else if (type.equals(Long.class)) {
                result[i] = 96L;
            } else if (type.equals(String.class)) {
                result[i] = "that";
            } else if (type.isArray()) {
                Object[] strArr;
                Class<?> arrayType = type.getComponentType();
                if (arrayType.equals(Integer.TYPE)) {
                    int[] intArr = new int[]{1, 3, 5};
                    result[i] = intArr;
                } else if (arrayType.equals(Long.TYPE)) {
                    long[] longArr = new long[]{1L, 9L, 25L};
                    result[i] = longArr;
                } else if (arrayType.equals(String.class)) {
                    strArr = new String[]{"blu", "red", "gro"};
                    result[i] = strArr;
                } else if (arrayType.equals(Date.class)) {
                    result[i] = strArr = new Date[]{new Date(), new Date()};
                }
            }
            if (result[i] == null) {
                result[i] = inputFiller.fillInput(type);
            }
            if (result[i] != null) continue;
            throw new IllegalStateException("Add logic for type: " + types[i].toString());
        }
        return result;
    }

    static {
        logger = LoggerFactory.getLogger(QueryBuilderCoverageTestUtil.class);
    }

    public static interface ModuleSpecificInputFiller {
        public Object fillInput(Class var1);
    }
}

