/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.prediction.pmml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jbpm.prediction.pmml.AbstractPMMLBackend;
import org.jbpm.prediction.pmml.PMMLLogisticRegressionConfiguration;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.prediction.PredictionOutcome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PMMLLogisticRegression
extends AbstractPMMLBackend {
    public static final String IDENTIFIER = "PMMLLogisticRegression";
    private static final Logger logger = LoggerFactory.getLogger(PMMLLogisticRegression.class);

    public PMMLLogisticRegression() {
        this(PMMLLogisticRegression.readConfigurationFromFile());
    }

    public PMMLLogisticRegression(PMMLLogisticRegressionConfiguration configuration) {
        this(configuration.getInputFeatures(), configuration.getOutcomeName(), configuration.getConfidenceThreshold(), configuration.getModelFile());
    }

    public PMMLLogisticRegression(List<String> inputFeatures, String outputFeatureName, double confidenceThreshold, File pmmlFile) {
        super(inputFeatures, outputFeatureName, confidenceThreshold, pmmlFile);
    }

    private static Properties readProperties(String propertiesFilename) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = PMMLLogisticRegression.class.getClassLoader().getResourceAsStream(propertiesFilename);
        if (inputStream == null) {
            throw new FileNotFoundException("Could not find the property file '" + propertiesFilename + "' in the classpath.");
        }
        properties.load(inputStream);
        return properties;
    }

    private static PMMLLogisticRegressionConfiguration readConfigurationFromFile() {
        PMMLLogisticRegressionConfiguration configuration = new PMMLLogisticRegressionConfiguration();
        ArrayList<String> inputFeatures = new ArrayList<String>();
        try {
            Properties inputProperties = PMMLLogisticRegression.readProperties("inputs.properties");
            for (Object propertyName : inputProperties.keySet()) {
                inputFeatures.add((String)propertyName);
            }
            configuration.setInputFeatures(inputFeatures);
            Properties outputProperties = PMMLLogisticRegression.readProperties("output.properties");
            configuration.setOutcomeName(outputProperties.getProperty("name"));
            configuration.setConfidenceThreshold(Double.parseDouble(outputProperties.getProperty("confidence_threshold")));
            Properties modelProperties = PMMLLogisticRegression.readProperties("model.properties");
            String pmmlFilename = modelProperties.getProperty("filename");
            configuration.setModelFile(new File(PMMLLogisticRegression.class.getClassLoader().getResource(pmmlFilename).getFile()));
            return configuration;
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not create service configuration.");
        }
    }

    @Override
    protected Map<String, Object> preProcess(Map<String, Object> data) {
        HashMap<String, Object> preProcessed = new HashMap<String, Object>();
        for (String input : data.keySet()) {
            if (input.equals("ActorId")) {
                String strValue = (String)data.get(input);
                int rawValue = strValue.equals("john") ? 0 : 1;
                preProcessed.put(input, rawValue);
                continue;
            }
            preProcessed.put(input, data.get(input));
        }
        return preProcessed;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public PredictionOutcome predict(Task task, Map<String, Object> data) {
        String predictionStr;
        Double confidence;
        Map<String, ?> result = this.evaluate(data);
        HashMap<String, Object> outcomes = new HashMap<String, Object>();
        Object predictionValue = result.get(this.outcomeFeatureName);
        if ((Integer)predictionValue == 0) {
            confidence = (Double)result.get("probability_0");
            predictionStr = "false";
        } else {
            confidence = (Double)result.get("probability_1");
            predictionStr = "true";
        }
        outcomes.put("approved", predictionStr);
        outcomes.put("confidence", confidence);
        logger.debug(data + ", prediction = " + predictionStr + ", confidence = " + confidence);
        return new PredictionOutcome(confidence.doubleValue(), this.confidenceThreshold, outcomes);
    }
}

