/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.impl.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jbpm.kie.test.util.AbstractBaseTest;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.impl.ManagedAuditEventBuilderImpl;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.cdi.impl.manager.InjectableRegisterableItemsFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@RunWith(value=Arquillian.class)
public class MultipleRuntimeManagerTest
extends AbstractBaseTest {
    @Inject
    private RuntimeManagerFactory managerFactory;
    @Inject
    private EntityManagerFactory emf;
    @Inject
    private BeanManager beanManager;

    @Deployment
    public static Archive<?> createDeployment() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jbpm-runtime-manager.jar")).addPackage("org.jbpm.services.task")).addPackage("org.jbpm.services.task.wih")).addPackage("org.jbpm.services.task.annotations")).addPackage("org.jbpm.services.task.api")).addPackage("org.jbpm.services.task.impl")).addPackage("org.jbpm.services.task.events")).addPackage("org.jbpm.services.task.exception")).addPackage("org.jbpm.services.task.identity")).addPackage("org.jbpm.services.task.factories")).addPackage("org.jbpm.services.task.internals")).addPackage("org.jbpm.services.task.internals.lifecycle")).addPackage("org.jbpm.services.task.lifecycle.listeners")).addPackage("org.jbpm.services.task.query")).addPackage("org.jbpm.services.task.util")).addPackage("org.jbpm.services.task.commands")).addPackage("org.jbpm.services.task.deadlines")).addPackage("org.jbpm.services.task.deadlines.notifications.impl")).addPackage("org.jbpm.services.task.subtask")).addPackage("org.jbpm.services.task.rule")).addPackage("org.jbpm.services.task.rule.impl")).addPackage("org.kie.internal.runtime.manager")).addPackage("org.kie.internal.runtime.manager.context")).addPackage("org.kie.internal.runtime.manager.cdi.qualifier")).addPackage("org.jbpm.runtime.manager.impl")).addPackage("org.jbpm.runtime.manager.impl.cdi")).addPackage("org.jbpm.runtime.manager.impl.factory")).addPackage("org.jbpm.runtime.manager.impl.jpa")).addPackage("org.jbpm.runtime.manager.impl.manager")).addPackage("org.jbpm.runtime.manager.impl.task")).addPackage("org.jbpm.runtime.manager.impl.tx")).addPackage("org.jbpm.shared.services.api")).addPackage("org.jbpm.shared.services.impl")).addPackage("org.jbpm.shared.services.impl.tx")).addPackage("org.jbpm.kie.services.api")).addPackage("org.jbpm.kie.services.impl")).addPackage("org.jbpm.kie.services.api.bpmn2")).addPackage("org.jbpm.kie.services.impl.bpmn2")).addPackage("org.jbpm.kie.services.impl.event.listeners")).addPackage("org.jbpm.kie.services.impl.audit")).addPackage("org.jbpm.kie.services.impl.form")).addPackage("org.jbpm.kie.services.impl.form.provider")).addPackage("org.jbpm.services.cdi")).addPackage("org.jbpm.services.cdi.impl")).addPackage("org.jbpm.services.cdi.impl.form")).addPackage("org.jbpm.services.cdi.impl.manager")).addPackage("org.jbpm.services.cdi.producer")).addPackage("org.jbpm.kie.services.test")).addPackage("org.jbpm.services.cdi.test")).addClass("org.jbpm.services.cdi.test.util.CDITestHelperNoTaskService")).addAsResource("jndi.properties", "jndi.properties")).addAsManifestResource("META-INF/persistence.xml", ArchivePaths.create((String)"persistence.xml"))).addAsManifestResource("META-INF/Taskorm.xml", ArchivePaths.create((String)"Taskorm.xml"))).addAsManifestResource("META-INF/beans.xml", ArchivePaths.create((String)"beans.xml"));
    }

    @BeforeClass
    public static void setup() {
        TestUtil.cleanupSingletonSessionId();
        Properties props = new Properties();
        props.setProperty("john", "user");
    }

    protected void close() {
    }

    protected void configureServices() {
    }

    @Test
    public void testAllManagersManager() {
        Assert.assertNotNull((Object)this.managerFactory);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AuditEventBuilder)new ManagedAuditEventBuilderImpl())).get();
        RuntimeManager manager = this.managerFactory.newSingletonRuntimeManager(environment);
        this.testProcessStartOnManager(manager, EmptyContext.get());
        manager.close();
        environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AuditEventBuilder)new ManagedAuditEventBuilderImpl())).get();
        manager = this.managerFactory.newPerRequestRuntimeManager(environment);
        this.testProcessStartOnManager(manager, EmptyContext.get());
        manager.close();
        environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-ScriptTask.bpmn2"), ResourceType.BPMN2).addAsset(ResourceFactory.newClassPathResource((String)"BPMN2-UserTask.bpmn2"), ResourceType.BPMN2).registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AuditEventBuilder)new ManagedAuditEventBuilderImpl())).get();
        manager = this.managerFactory.newPerProcessInstanceRuntimeManager(environment);
        this.testProcessStartOnManager(manager, (Context<?>)ProcessInstanceIdContext.get());
        manager.close();
    }

    private void testProcessStartOnManager(RuntimeManager manager, Context<?> context) {
        Assert.assertNotNull((Object)manager);
        RuntimeEngine runtime = manager.getRuntimeEngine(context);
        Assert.assertNotNull((Object)runtime);
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertNotNull((Object)processInstance);
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = runtime.getTaskService().getTasksOwnedByStatus("john", statuses, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findActiveProcessInstances("UserTask");
        Assert.assertNotNull((Object)logs);
        Assert.assertEquals((long)1L, (long)logs.size());
        String externalId = ((ProcessInstanceLog)logs.get(0)).getExternalId();
        Assert.assertEquals((Object)manager.getIdentifier(), (Object)externalId);
        runtime.getTaskService().start(((TaskSummary)tasks.get(0)).getId().longValue(), "john");
        runtime.getTaskService().complete(((TaskSummary)tasks.get(0)).getId().longValue(), "john", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }
}

