/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.test;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jbpm.kie.services.impl.audit.ServicesAwareAuditEventBuilder;
import org.jbpm.kie.services.test.TestIdentityProvider;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.process.audit.AbstractAuditLogger;
import org.jbpm.process.audit.AuditLoggerFactory;
import org.jbpm.process.audit.event.AuditEventBuilder;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.api.RuntimeDataService;
import org.jbpm.services.api.model.NodeInstanceDesc;
import org.jbpm.services.cdi.impl.manager.InjectableRegisterableItemsFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.identity.IdentityProvider;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.query.QueryContext;
import org.kie.internal.runtime.manager.context.EmptyContext;

@RunWith(value=Arquillian.class)
public class RuntimeDataServiceTest
extends AbstractKieServicesBaseTest {
    @Inject
    private EntityManagerFactory emf;
    @Inject
    private BeanManager beanManager;
    @Inject
    private RuntimeDataService runtimeDataService;
    @Inject
    private RuntimeManagerFactory managerFactory;

    @Deployment
    public static Archive<?> createDeployment() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"domain-services.jar")).addPackage("org.jbpm.services.task")).addPackage("org.jbpm.services.task.wih")).addPackage("org.jbpm.services.task.annotations")).addPackage("org.jbpm.services.task.api")).addPackage("org.jbpm.services.task.impl")).addPackage("org.jbpm.services.task.events")).addPackage("org.jbpm.services.task.exception")).addPackage("org.jbpm.services.task.identity")).addPackage("org.jbpm.services.task.factories")).addPackage("org.jbpm.services.task.internals")).addPackage("org.jbpm.services.task.internals.lifecycle")).addPackage("org.jbpm.services.task.lifecycle.listeners")).addPackage("org.jbpm.services.task.query")).addPackage("org.jbpm.services.task.util")).addPackage("org.jbpm.services.task.commands")).addPackage("org.jbpm.services.task.deadlines")).addPackage("org.jbpm.services.task.deadlines.notifications.impl")).addPackage("org.jbpm.services.task.subtask")).addPackage("org.jbpm.services.task.rule")).addPackage("org.jbpm.services.task.rule.impl")).addPackage("org.kie.internal.runtime.manager")).addPackage("org.kie.internal.runtime.manager.context")).addPackage("org.kie.internal.runtime.manager.cdi.qualifier")).addPackage("org.jbpm.runtime.manager.impl")).addPackage("org.jbpm.runtime.manager.impl.cdi")).addPackage("org.jbpm.runtime.manager.impl.factory")).addPackage("org.jbpm.runtime.manager.impl.jpa")).addPackage("org.jbpm.runtime.manager.impl.manager")).addPackage("org.jbpm.runtime.manager.impl.task")).addPackage("org.jbpm.runtime.manager.impl.tx")).addPackage("org.jbpm.shared.services.api")).addPackage("org.jbpm.shared.services.impl")).addPackage("org.jbpm.shared.services.impl.tx")).addPackage("org.jbpm.kie.services.api")).addPackage("org.jbpm.kie.services.impl")).addPackage("org.jbpm.kie.services.api.bpmn2")).addPackage("org.jbpm.kie.services.impl.bpmn2")).addPackage("org.jbpm.kie.services.impl.event.listeners")).addPackage("org.jbpm.kie.services.impl.audit")).addPackage("org.jbpm.kie.services.impl.form")).addPackage("org.jbpm.kie.services.impl.form.provider")).addPackage("org.jbpm.services.cdi")).addPackage("org.jbpm.services.cdi.impl")).addPackage("org.jbpm.services.cdi.impl.form")).addPackage("org.jbpm.services.cdi.impl.manager")).addPackage("org.jbpm.services.cdi.producer")).addPackage("org.jbpm.kie.services.test")).addPackage("org.jbpm.services.cdi.test")).addClass("org.jbpm.services.cdi.test.util.CDITestHelperNoTaskService")).addAsResource("jndi.properties", "jndi.properties")).addAsManifestResource("META-INF/persistence.xml", ArchivePaths.create((String)"persistence.xml"))).addAsManifestResource("META-INF/beans.xml", ArchivePaths.create((String)"beans.xml"));
    }

    @BeforeClass
    public static void setup() {
        TestUtil.cleanupSingletonSessionId();
    }

    protected void close() {
    }

    protected void configureServices() {
    }

    @After
    public void tearDownTest() {
    }

    @Test
    public void testGetProcessInstanceHistory() throws IOException {
        Assert.assertNotNull((Object)this.managerFactory);
        String id = "custom-manager";
        AbstractAuditLogger auditLogger = AuditLoggerFactory.newJPAInstance();
        ServicesAwareAuditEventBuilder auditEventBuilder = new ServicesAwareAuditEventBuilder();
        auditEventBuilder.setIdentityProvider((IdentityProvider)new TestIdentityProvider());
        auditEventBuilder.setDeploymentUnitId(id);
        auditLogger.setBuilder((AuditEventBuilder)auditEventBuilder);
        RuntimeEnvironmentBuilder builder = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).registerableItemsFactory(InjectableRegisterableItemsFactory.getFactory((BeanManager)this.beanManager, (AbstractAuditLogger)auditLogger));
        builder.addAsset(ResourceFactory.newClassPathResource((String)"repo/processes/general/hello.bpmn"), ResourceType.BPMN2);
        RuntimeManager manager = this.managerFactory.newSingletonRuntimeManager(builder.get(), id);
        RuntimeEngine runtime = manager.getRuntimeEngine(EmptyContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("hello");
        Collection nodeInstanceLogs = this.runtimeDataService.getProcessInstanceHistoryCompleted(processInstance.getId(), new QueryContext());
        Iterator iterator = nodeInstanceLogs.iterator();
        NodeInstanceDesc log0 = (NodeInstanceDesc)iterator.next();
        Assert.assertEquals((Object)"End", (Object)log0.getName());
        NodeInstanceDesc log1 = (NodeInstanceDesc)iterator.next();
        Assert.assertEquals((Object)"Hello", (Object)log1.getName());
        NodeInstanceDesc log2 = (NodeInstanceDesc)iterator.next();
        Assert.assertEquals((Object)"Start", (Object)log2.getName());
        Collection fullNodeInstanceLogs = this.runtimeDataService.getProcessInstanceFullHistory(processInstance.getId(), new QueryContext());
        Iterator fullIterator = fullNodeInstanceLogs.iterator();
        NodeInstanceDesc fullLog0 = (NodeInstanceDesc)fullIterator.next();
        Assert.assertEquals((Object)"Start", (Object)fullLog0.getName());
        Assert.assertEquals((Object)true, (Object)fullLog0.isCompleted());
        NodeInstanceDesc fullLog1 = (NodeInstanceDesc)fullIterator.next();
        Assert.assertEquals((Object)"Hello", (Object)fullLog1.getName());
        Assert.assertEquals((Object)true, (Object)fullLog1.isCompleted());
        NodeInstanceDesc fullLog2 = (NodeInstanceDesc)fullIterator.next();
        Assert.assertEquals((Object)"End", (Object)fullLog2.getName());
        Assert.assertEquals((Object)true, (Object)fullLog2.isCompleted());
        NodeInstanceDesc fullLog3 = (NodeInstanceDesc)fullIterator.next();
        Assert.assertEquals((Object)"End", (Object)fullLog3.getName());
        Assert.assertEquals((Object)false, (Object)fullLog3.isCompleted());
        NodeInstanceDesc fullLog4 = (NodeInstanceDesc)fullIterator.next();
        Assert.assertEquals((Object)"Hello", (Object)fullLog4.getName());
        Assert.assertEquals((Object)false, (Object)fullLog4.isCompleted());
        NodeInstanceDesc fullLog5 = (NodeInstanceDesc)fullIterator.next();
        Assert.assertEquals((Object)"Start", (Object)fullLog5.getName());
        Assert.assertEquals((Object)false, (Object)fullLog5.isCompleted());
        manager.close();
    }
}

