/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.cdi.impl.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.drools.core.event.DebugProcessEventListener;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.process.audit.JPAWorkingMemoryDbLogger;
import org.jbpm.runtime.manager.impl.PerProcessInstanceRuntimeManager;
import org.jbpm.runtime.manager.impl.RuntimeEngineImpl;
import org.jbpm.runtime.manager.util.TestUtil;
import org.jbpm.services.task.audit.JPATaskLifeCycleEventListener;
import org.jbpm.services.task.lifecycle.listeners.BAMTaskEventListener;
import org.jbpm.services.task.wih.ExternalTaskEventListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.cdi.qualifier.PerProcessInstance;
import org.kie.internal.runtime.manager.cdi.qualifier.PerRequest;
import org.kie.internal.runtime.manager.cdi.qualifier.Singleton;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.EventService;

@RunWith(value=Arquillian.class)
public class SingleRuntimeManagerWithListenersTest
extends AbstractKieServicesBaseTest {
    @Inject
    @Singleton
    private RuntimeManager singletonManager;
    @Inject
    @PerRequest
    private RuntimeManager perRequestManager;
    @Inject
    @PerProcessInstance
    private RuntimeManager perProcessInstanceManager;

    @Deployment
    public static Archive<?> createDeployment() {
        return ((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"jbpm-runtime-manager.jar")).addPackage("org.jbpm.services.task")).addPackage("org.jbpm.services.task.wih")).addPackage("org.jbpm.services.task.annotations")).addPackage("org.jbpm.services.task.api")).addPackage("org.jbpm.services.task.impl")).addPackage("org.jbpm.services.task.events")).addPackage("org.jbpm.services.task.exception")).addPackage("org.jbpm.services.task.identity")).addPackage("org.jbpm.services.task.factories")).addPackage("org.jbpm.services.task.internals")).addPackage("org.jbpm.services.task.internals.lifecycle")).addPackage("org.jbpm.services.task.lifecycle.listeners")).addPackage("org.jbpm.services.task.query")).addPackage("org.jbpm.services.task.util")).addPackage("org.jbpm.services.task.commands")).addPackage("org.jbpm.services.task.deadlines")).addPackage("org.jbpm.services.task.deadlines.notifications.impl")).addPackage("org.jbpm.services.task.subtask")).addPackage("org.jbpm.services.task.rule")).addPackage("org.jbpm.services.task.rule.impl")).addPackage("org.jbpm.services.task.audit.service")).addPackage("org.kie.internal.runtime.manager")).addPackage("org.kie.internal.runtime.manager.context")).addPackage("org.kie.internal.runtime.manager.cdi.qualifier")).addPackage("org.jbpm.runtime.manager.impl")).addPackage("org.jbpm.runtime.manager.impl.cdi")).addPackage("org.jbpm.runtime.manager.impl.factory")).addPackage("org.jbpm.runtime.manager.impl.jpa")).addPackage("org.jbpm.runtime.manager.impl.manager")).addPackage("org.jbpm.runtime.manager.impl.task")).addPackage("org.jbpm.runtime.manager.impl.tx")).addPackage("org.jbpm.shared.services.api")).addPackage("org.jbpm.shared.services.impl")).addPackage("org.jbpm.shared.services.impl.tx")).addPackage("org.jbpm.kie.services.api")).addPackage("org.jbpm.kie.services.impl")).addPackage("org.jbpm.kie.services.api.bpmn2")).addPackage("org.jbpm.kie.services.impl.bpmn2")).addPackage("org.jbpm.kie.services.impl.event.listeners")).addPackage("org.jbpm.kie.services.impl.audit")).addPackage("org.jbpm.kie.services.impl.form")).addPackage("org.jbpm.kie.services.impl.form.provider")).addPackage("org.jbpm.services.cdi.impl.producers")).addPackage("org.jbpm.kie.services.impl.query")).addPackage("org.jbpm.kie.services.impl.query.mapper")).addPackage("org.jbpm.kie.services.impl.query.persistence")).addPackage("org.jbpm.kie.services.impl.query.preprocessor")).addPackage("org.jbpm.services.cdi")).addPackage("org.jbpm.services.cdi.impl")).addPackage("org.jbpm.services.cdi.impl.form")).addPackage("org.jbpm.services.cdi.impl.manager")).addPackage("org.jbpm.services.cdi.producer")).addPackage("org.jbpm.services.cdi.impl.security")).addPackage("org.jbpm.services.cdi.impl.query")).addPackage("org.jbpm.kie.services.test")).addPackage("org.jbpm.services.cdi.test")).addClass("org.jbpm.services.cdi.test.util.CDITestHelperNoTaskService")).addClass("org.jbpm.services.cdi.test.util.CountDownDeploymentListenerCDIImpl")).addClass("org.jbpm.kie.services.test.objects.CountDownDeploymentListener")).addAsResource("jndi.properties", "jndi.properties")).addAsManifestResource("META-INF/persistence.xml", ArchivePaths.create((String)"persistence.xml"))).addAsManifestResource("META-INF/Taskorm.xml", ArchivePaths.create((String)"Taskorm.xml"))).addAsManifestResource("META-INF/beans.xml", ArchivePaths.create((String)"beans.xml"));
    }

    @BeforeClass
    public static void setup() {
        TestUtil.cleanupSingletonSessionId();
        Properties props = new Properties();
        props.setProperty("john", "user");
    }

    @After
    public void close() {
        this.singletonManager.close();
        this.perRequestManager.close();
        this.perProcessInstanceManager.close();
    }

    protected void configureServices() {
    }

    @Test
    public void testSingleSingletonManager() {
        Assert.assertNotNull((Object)this.singletonManager);
        RuntimeEngine runtime = this.singletonManager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)runtime);
        this.testProcessStartOnManager(runtime);
        this.singletonManager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testSinglePerRequestManager() {
        Assert.assertNotNull((Object)this.perRequestManager);
        RuntimeEngine runtime = this.perRequestManager.getRuntimeEngine(EmptyContext.get());
        Assert.assertNotNull((Object)runtime);
        this.testProcessStartOnManager(runtime);
        this.perRequestManager.disposeRuntimeEngine(runtime);
    }

    @Test
    public void testSinglePerProcessInstanceManager() {
        Assert.assertNotNull((Object)this.perProcessInstanceManager);
        RuntimeEngine runtime = this.perProcessInstanceManager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        Assert.assertNotNull((Object)runtime);
        this.testProcessStartOnManager(runtime);
        this.perProcessInstanceManager.disposeRuntimeEngine(runtime);
    }

    private void testProcessStartOnManager(RuntimeEngine runtime) {
        KieSession ksession = runtime.getKieSession();
        Assert.assertNotNull((Object)ksession);
        Collection pListeners = ksession.getProcessEventListeners();
        Assert.assertNotNull((Object)pListeners);
        ArrayList<String> listenerCLassNames = new ArrayList<String>();
        for (Object o : pListeners) {
            listenerCLassNames.add(o.getClass().getName());
        }
        Assert.assertTrue((boolean)listenerCLassNames.contains(DebugProcessEventListener.class.getName()));
        Assert.assertTrue((boolean)listenerCLassNames.contains(JPAWorkingMemoryDbLogger.class.getName()));
        if (((RuntimeEngineImpl)runtime).getManager() instanceof PerProcessInstanceRuntimeManager) {
            Assert.assertEquals((long)3L, (long)pListeners.size());
        } else {
            Assert.assertEquals((long)2L, (long)pListeners.size());
        }
        TaskService taskService = runtime.getTaskService();
        Assert.assertNotNull((Object)taskService);
        List listeners = ((EventService)taskService).getTaskEventListeners();
        Assert.assertNotNull((Object)listeners);
        Assert.assertEquals((long)3L, (long)listeners.size());
        listenerCLassNames = new ArrayList();
        for (Object o : listeners) {
            System.out.println("###### " + o.getClass().getName());
            listenerCLassNames.add(o.getClass().getName());
        }
        Assert.assertEquals((long)3L, (long)listenerCLassNames.size());
        Assert.assertTrue((boolean)listenerCLassNames.contains(JPATaskLifeCycleEventListener.class.getName()));
        Assert.assertTrue((boolean)listenerCLassNames.contains(ExternalTaskEventListener.class.getName()));
        Assert.assertTrue((boolean)listenerCLassNames.contains(BAMTaskEventListener.class.getName()));
        ProcessInstance processInstance = ksession.startProcess("UserTask");
        Assert.assertNotNull((Object)processInstance);
        ArrayList<Status> statuses = new ArrayList<Status>();
        statuses.add(Status.Reserved);
        List tasks = taskService.getTasksOwnedByStatus("john", statuses, "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskService.start(((TaskSummary)tasks.get(0)).getId().longValue(), "john");
        taskService.complete(((TaskSummary)tasks.get(0)).getId().longValue(), "john", null);
        processInstance = ksession.getProcessInstance(processInstance.getId());
        Assert.assertNull((Object)processInstance);
    }
}

