/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.jbpm.shared.services.api.FileException;
import org.jbpm.shared.services.api.FileService;
import org.kie.commons.io.FileSystemType;
import org.kie.commons.io.IOService;
import org.kie.commons.io.impl.IOServiceNio2WrapperImpl;
import org.kie.commons.java.nio.IOException;
import org.kie.commons.java.nio.file.CopyOption;
import org.kie.commons.java.nio.file.DirectoryStream;
import org.kie.commons.java.nio.file.Files;
import org.kie.commons.java.nio.file.LinkOption;
import org.kie.commons.java.nio.file.OpenOption;
import org.kie.commons.java.nio.file.Path;
import org.kie.commons.java.nio.file.attribute.FileAttribute;
import org.kie.commons.validation.PortablePreconditions;

@ApplicationScoped
public class VFSFileServiceImpl
implements FileService {
    private static final String REPO_PLAYGROUND = "git://jbpm-playground";
    private static final String ORIGIN_URL = "https://github.com/guvnorngtestuser1/jbpm-console-ng-playground.git";
    private final IOService ioService = new IOServiceNio2WrapperImpl();

    @Override
    @PostConstruct
    public void init() {
        if (this.ioService.getFileSystem(URI.create(REPO_PLAYGROUND)) != null) {
            this.fetchChanges();
        } else {
            try {
                String userName = "guvnorngtestuser1";
                String password = "test1234";
                URI fsURI = URI.create(REPO_PLAYGROUND);
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("username", "guvnorngtestuser1");
                env.put("password", "test1234");
                env.put("origin", ORIGIN_URL);
                this.ioService.newFileSystem(fsURI, env, (FileSystemType)FileSystemType.Bootstrap.BOOTSTRAP_INSTANCE);
            }
            catch (Exception e) {
                System.out.println(">>>>>>>>>>>>>>>>>>> E " + e.getMessage());
            }
        }
    }

    @Override
    public void fetchChanges() {
        this.ioService.getFileSystem(URI.create("git://jbpm-playground?fetch"));
    }

    @Override
    public byte[] loadFile(String path) throws FileException {
        Path file = this.ioService.get("git://jbpm-playground/" + path, new String[0]);
        PortablePreconditions.checkNotNull((String)"file", (Object)file);
        try {
            return this.ioService.readAllBytes(file);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), ex);
        }
    }

    @Override
    public byte[] loadFile(Path file) throws FileException {
        PortablePreconditions.checkNotNull((String)"file", (Object)file);
        try {
            return this.ioService.readAllBytes(file);
        }
        catch (IOException ex) {
            throw new FileException(ex.getMessage(), ex);
        }
    }

    @Override
    public Iterable<Path> loadFilesByType(String path, final String fileType) {
        return this.ioService.newDirectoryStream(this.ioService.get("git://jbpm-playground/" + path, new String[0]), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) throws IOException {
                return !Files.isDirectory((Path)entry, (LinkOption[])new LinkOption[0]) && entry.getFileName().toString().endsWith(fileType);
            }
        });
    }

    @Produces
    @Named(value="ioStrategy")
    public IOService ioService() {
        return this.ioService;
    }

    @Override
    public boolean exists(Path file) {
        return this.ioService.exists(file);
    }

    @Override
    public boolean exists(String file) {
        Path path = this.ioService.get("git://jbpm-playground/" + file, new String[0]);
        return this.ioService.exists(path);
    }

    @Override
    public void move(String source, String dest) {
        this.copy(source, dest);
        this.ioService.delete(this.ioService.get("git://jbpm-playground/" + source, new String[0]));
    }

    @Override
    public void copy(String source, String dest) {
        PortablePreconditions.checkNotNull((String)"source", (Object)source);
        PortablePreconditions.checkNotNull((String)"dest", (Object)dest);
        Path sourcePath = this.ioService.get("git://jbpm-playground/" + source, new String[0]);
        Path targetPath = this.ioService.get("git://jbpm-playground/" + dest, new String[0]);
        this.ioService.copy(sourcePath, targetPath, new CopyOption[0]);
    }

    @Override
    public Path createDirectory(String path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.createDirectory(this.ioService.get("git://jbpm-playground/" + path, new String[0]), new FileAttribute[0]);
    }

    @Override
    public boolean deleteIfExists(String path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.deleteIfExists(this.ioService.get("git://jbpm-playground/" + path, new String[0]));
    }

    @Override
    public OutputStream openFile(String path) {
        PortablePreconditions.checkNotNull((String)"path", (Object)path);
        return this.ioService.newOutputStream(this.ioService.get("git://jbpm-playground/" + path, new String[0]), new OpenOption[0]);
    }
}

