/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.drools.persistence.TransactionSynchronization;
import org.jbpm.shared.services.api.JbpmServicesTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JbpmLocalTransactionManager
implements JbpmServicesTransactionManager {
    private static final Logger logger = LoggerFactory.getLogger(JbpmLocalTransactionManager.class);

    @Override
    public void attachPersistenceContext(EntityManager em) {
    }

    @Override
    public boolean begin(EntityManager em) {
        boolean begun = false;
        if (this.getStatus(em) == 3) {
            try {
                em.getTransaction().begin();
                begun = true;
            }
            catch (Exception e) {
                logger.warn("Unable to begin transaction", (Throwable)e);
                throw new RuntimeException("Unable to begin transaction", e);
            }
        }
        return begun;
    }

    @Override
    public void commit(EntityManager em, boolean txOwner) {
        try {
            if (txOwner) {
                em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            logger.warn("Unable to commit transaction", (Throwable)e);
            throw new RuntimeException("Unable to commit transaction", e);
        }
    }

    @Override
    public void rollback(EntityManager em, boolean txOwner) {
        if (this.getStatus(em) == 3) {
            return;
        }
        try {
            if (txOwner) {
                em.getTransaction().rollback();
            } else {
                em.getTransaction().setRollbackOnly();
            }
        }
        catch (Exception e) {
            logger.warn("Unable to rollback transaction", (Throwable)e);
            throw new RuntimeException("Unable to rollback transaction", e);
        }
    }

    @Override
    public int getStatus(EntityManager em) {
        EntityTransaction tx = em.getTransaction();
        if (tx.isActive()) {
            return 4;
        }
        return 3;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void registerTXSynchronization(TransactionSynchronization txSync) {
    }

    @Override
    public boolean supportsTXSynchronization() {
        return false;
    }
}

