/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import java.util.HashMap;
import org.jbpm.shared.services.impl.QueryManager;
import org.junit.Assert;
import org.junit.Test;

public class QueryManagerTest {
    @Test
    public void testLoadQueriesNotFound() {
        QueryManager manager = new QueryManager();
        manager.addNamedQueries("test-orm.xml");
        String query = manager.getQuery("test-query-1", null);
        Assert.assertNull((Object)query);
    }

    @Test
    public void testLoadQueriesFound() {
        QueryManager manager = new QueryManager();
        manager.addNamedQueries("test-orm.xml");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderby", "log.date");
        String query = manager.getQuery("test-query-3", params);
        Assert.assertNotNull((Object)query);
        Assert.assertTrue((boolean)query.endsWith("ORDER BY log.date"));
    }

    @Test
    public void testLoadQueriesFoundAsc() {
        QueryManager manager = new QueryManager();
        manager.addNamedQueries("test-orm.xml");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderby", "log.date");
        params.put("asc", "true");
        String query = manager.getQuery("test-query-3", params);
        Assert.assertNotNull((Object)query);
        Assert.assertTrue((boolean)query.endsWith("ORDER BY log.date ASC"));
    }

    @Test
    public void testLoadQueriesFoundDesc() {
        QueryManager manager = new QueryManager();
        manager.addNamedQueries("test-orm.xml");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("orderby", "log.date");
        params.put("desc", "true");
        String query = manager.getQuery("test-query-3", params);
        Assert.assertNotNull((Object)query);
        Assert.assertTrue((boolean)query.endsWith("ORDER BY log.date DESC"));
    }
}

