/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.shared.services.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.jbpm.shared.services.impl.QueryManager;
import org.kie.api.runtime.Context;

public class JpaPersistenceContext
implements Context {
    public static final String FIRST_RESULT = "firstResult";
    public static final String MAX_RESULTS = "maxResults";
    private EntityManager em;

    public JpaPersistenceContext(EntityManager em) {
        this.em = em;
    }

    protected Query getQueryByName(String queryName, Map<String, Object> params) {
        String queryStr = QueryManager.get().getQuery(queryName, params);
        Query query = null;
        query = queryStr != null ? this.em.createQuery(queryStr) : this.em.createNamedQuery(queryName);
        return query;
    }

    protected LockModeType getLockMode(String queryName, Map<String, Object> params) {
        return QueryManager.get().getQuery(queryName, params) != null ? LockModeType.NONE : null;
    }

    public <T> T queryWithParametersInTransaction(String queryName, Map<String, Object> params, Class<T> clazz) {
        this.check();
        Query query = this.getQueryByName(queryName, params);
        return this.queryStringWithParameters(params, false, this.getLockMode(queryName, params), clazz, query);
    }

    public <T> T queryAndLockWithParametersInTransaction(String queryName, Map<String, Object> params, boolean singleResult, Class<T> clazz) {
        this.check();
        Query query = this.getQueryByName(queryName, params);
        return this.queryStringWithParameters(params, singleResult, LockModeType.PESSIMISTIC_WRITE, clazz, query);
    }

    public <T> T queryInTransaction(String queryName, Class<T> clazz) {
        this.check();
        Query query = this.em.createNamedQuery(queryName);
        return (T)query.getResultList();
    }

    public <T> T queryStringInTransaction(String queryString, Class<T> clazz) {
        this.check();
        Query query = this.em.createQuery(queryString);
        return (T)query.getResultList();
    }

    public <T> List<T> nativeQueryStringWithParametersInTransaction(String queryString, Map<String, Object> params, Class<T> clazz) {
        this.check();
        Query query = this.em.createNativeQuery(queryString);
        params.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return query.getResultList();
    }

    public <T> T queryStringWithParametersInTransaction(String queryString, Map<String, Object> params, Class<T> clazz) {
        this.check();
        Query query = this.em.createQuery(queryString);
        return this.queryStringWithParameters(params, false, LockModeType.NONE, clazz, query);
    }

    public <T> T queryAndLockStringWithParametersInTransaction(String queryName, Map<String, Object> params, boolean singleResult, Class<T> clazz) {
        this.check();
        Query query = this.em.createNamedQuery(queryName);
        return this.queryStringWithParameters(params, singleResult, LockModeType.PESSIMISTIC_WRITE, clazz, query);
    }

    public int executeUpdateString(String updateString) {
        this.check();
        Query query = this.em.createQuery(updateString);
        return query.executeUpdate();
    }

    public int executeUpdateString(String updateString, Map<String, Object> parameters) {
        this.check();
        Query query = this.em.createQuery(updateString);
        if (parameters != null && !parameters.isEmpty()) {
            for (String name : parameters.keySet()) {
                query.setParameter(name, parameters.get(name));
            }
        }
        return query.executeUpdate();
    }

    public HashMap<String, Object> addParametersToMap(Object ... parameterValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (parameterValues.length % 2 != 0) {
            throw new RuntimeException("Expected an even number of parameters, not " + parameterValues.length);
        }
        for (int i = 0; i < parameterValues.length; ++i) {
            String parameterName = null;
            if (!(parameterValues[i] instanceof String)) {
                throw new RuntimeException("Expected a String as the parameter name, not a " + parameterValues[i].getClass().getSimpleName());
            }
            parameterName = (String)parameterValues[i];
            parameters.put(parameterName, parameterValues[++i]);
        }
        return parameters;
    }

    public <T> T persist(T object) {
        this.check();
        this.em.persist(object);
        return object;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.check();
        return (T)this.em.find(entityClass, primaryKey);
    }

    public <T> T remove(T entity) {
        this.check();
        this.em.remove(entity);
        return entity;
    }

    public <T> T merge(T entity) {
        this.check();
        return (T)this.em.merge(entity);
    }

    private <T> T queryStringWithParameters(Map<String, Object> params, boolean singleResult, LockModeType lockMode, Class<T> clazz, Query query) {
        if (lockMode != null) {
            query.setLockMode(lockMode);
        }
        if (params != null && !params.isEmpty()) {
            for (String name : params.keySet()) {
                if (FIRST_RESULT.equals(name)) {
                    query.setFirstResult(((Integer)params.get(name)).intValue());
                    continue;
                }
                if (MAX_RESULTS.equals(name)) {
                    if ((Integer)params.get(name) <= 0) continue;
                    query.setMaxResults(((Integer)params.get(name)).intValue());
                    continue;
                }
                if ("asc".equals(name) || "desc".equals(name) || "orderby".equals(name) || "filter".equals(name)) continue;
                query.setParameter(name, params.get(name));
            }
        }
        if (singleResult) {
            return (T)query.getSingleResult();
        }
        return (T)query.getResultList();
    }

    public boolean isOpen() {
        if (this.em == null) {
            return false;
        }
        return this.em.isOpen();
    }

    public void joinTransaction() {
        if (this.em == null) {
            return;
        }
        this.em.joinTransaction();
    }

    public void close(boolean txOwner, boolean emOwner) {
        this.check();
        if (txOwner) {
            this.em.clear();
        }
        if (emOwner) {
            this.em.close();
        }
    }

    protected void check() {
        if (this.em == null || !this.em.isOpen()) {
            throw new IllegalStateException("Entity manager is null or is closed, exiting...");
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    public Object get(String identifier) {
        return null;
    }

    public void set(String identifier, Object value) {
    }

    public void remove(String identifier) {
    }

    public boolean has(String identifier) {
        return false;
    }
}

