/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.persistence.Persistence;
import org.jbpm.process.core.timer.impl.ThreadPoolSchedulerService;
import org.jbpm.test.functional.timer.GlobalTimerServiceBaseTest;
import org.jbpm.test.functional.timer.TimerBaseTest;
import org.jbpm.test.functional.timer.addon.TransactionalThreadPoolSchedulerService;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.SessionNotFoundException;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@RunWith(value=Parameterized.class)
public class GlobalThreadPoolTimerServiceTest
extends GlobalTimerServiceBaseTest {
    private int managerType;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{1}, {2}, {3}};
        return Arrays.asList(data);
    }

    public GlobalThreadPoolTimerServiceTest(int managerType) {
        this.managerType = managerType;
    }

    @Before
    public void setUp() {
        GlobalThreadPoolTimerServiceTest.cleanupSingletonSessionId();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
        this.globalScheduler = new ThreadPoolSchedulerService(1);
    }

    @After
    public void tearDown() {
        try {
            this.globalScheduler.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanup();
    }

    @Override
    protected RuntimeManager getManager(RuntimeEnvironment environment, boolean waitOnStart) {
        if (this.managerType == 1) {
            return RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        }
        if (this.managerType == 2) {
            return RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        }
        if (this.managerType == 3) {
            return RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        }
        throw new IllegalArgumentException("Invalid runtime maanger type");
    }

    @Test
    public void testInterediateTimerWithGlobalTestServiceWithinTransaction() throws Exception {
        int badNumTimers = 4;
        final CountDownLatch timerCompleted = new CountDownLatch(badNumTimers);
        this.globalScheduler = new TransactionalThreadPoolSchedulerService(3);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                    timerCompleted.countDown();
                }
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, (ProcessEventListener)listener)).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        GlobalThreadPoolTimerServiceTest.assertTrue((processInstance.getState() == 1 ? 1 : 0) != 0);
        boolean didNotWait = timerCompleted.await(2L, TimeUnit.SECONDS);
        GlobalThreadPoolTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        this.manager.disposeRuntimeEngine(runtime);
        didNotWait = timerCompleted.await(2L, TimeUnit.SECONDS);
        GlobalThreadPoolTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        try {
            runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
            ksession = runtime.getKieSession();
            processInstance = ksession.getProcessInstance(processInstance.getId());
            GlobalThreadPoolTimerServiceTest.assertNull((Object)processInstance);
        }
        catch (SessionNotFoundException sessionNotFoundException) {
            // empty catch block
        }
        didNotWait = timerCompleted.await(3L, TimeUnit.SECONDS);
        GlobalThreadPoolTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        GlobalThreadPoolTimerServiceTest.assertEquals((long)3L, (long)timerExporations.size());
        this.manager.disposeRuntimeEngine(runtime);
    }
}

