/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.runtime.manager.impl.task.SynchronizedTaskService;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.query.QueryFilter;
import qa.tools.ikeeper.annotation.BZ;

public class HumanTaskQueryFilterTest
extends JbpmTestCase {
    private static final String CONF_HUMAN_TASK = "org/jbpm/test/functional/task/HumanTaskQueryFilter-configurableHumanTask.bpmn2";
    private static final String CONF_HUMAN_TASK_ID = "org.jbpm.test.functional.task.HumanTaskQueryFilter-configurableHumanTask";
    private KieSession kieSession;
    private SynchronizedTaskService taskService;
    private List<ProcessInstance> instanceList;

    public HumanTaskQueryFilterTest() {
        super(true, true);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.createRuntimeManager(new String[]{CONF_HUMAN_TASK});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        this.kieSession = runtimeEngine.getKieSession();
        this.taskService = (SynchronizedTaskService)runtimeEngine.getTaskService();
        this.instanceList = new ArrayList<ProcessInstance>();
    }

    @Test
    public void testFirstResult() {
        this.startHumanTaskProcess(6, "john's task", "john");
        List taskList = this.taskService.getTasksAssignedAsPotentialOwner("john", null, null, new QueryFilter(2, 2, "t.name", true));
        this.logger.info("### Potential owner task list: " + taskList);
        Assertions.assertThat((List)taskList).hasSize(2);
        for (int i = 0; i < taskList.size(); ++i) {
            Assertions.assertThat((String)((TaskSummary)taskList.get(i)).getName()).isEqualTo((Object)("john's task " + (i + 1 + 2)));
        }
        this.abortHumanTaskProcess(6);
    }

    @Test
    public void testMaxResults() {
        this.startHumanTaskProcess(4, "john's task", "john");
        List taskList = this.taskService.getTasksAssignedAsPotentialOwner("john", null, null, new QueryFilter(0, 2, "t.id", true));
        Assertions.assertThat((List)taskList).hasSize(2);
        this.logger.info("### Potential owner task list: " + taskList);
        taskList = this.taskService.getTasksOwned("john", null, new QueryFilter(0, 1, false, null, "en-UK", null));
        Assertions.assertThat((List)taskList).hasSize(1);
        this.logger.info("### Owned task list: " + taskList);
        this.abortHumanTaskProcess(4);
    }

    @Test
    public void testDescendingOrder() {
        this.startHumanTaskProcess(3, "john's task", "john");
        List taskList = this.taskService.getTasksAssignedAsPotentialOwner("john", null, null, new QueryFilter(0, 0, "t.name", false));
        this.logger.info("### Potential owner task list: " + taskList);
        Assertions.assertThat((List)taskList).hasSize(3);
        for (int i = 0; i < taskList.size(); ++i) {
            this.logger.info("### Task Name: " + ((TaskSummary)taskList.get(i)).getName());
            Assertions.assertThat((String)((TaskSummary)taskList.get(i)).getName()).isEqualTo((Object)("john's task " + (3 - i)));
        }
        this.abortHumanTaskProcess(3);
    }

    @Test
    public void testAscendingOrder() {
        this.startHumanTaskProcess(3, "john's task", "john");
        List taskList = this.taskService.getTasksAssignedAsPotentialOwner("john", null, null, new QueryFilter(0, 0, "t.name", true));
        this.logger.info("### Potential owner task list: " + taskList);
        Assertions.assertThat((List)taskList).hasSize(3);
        for (int i = 0; i < taskList.size(); ++i) {
            this.logger.info("### Task Name: " + ((TaskSummary)taskList.get(i)).getName());
            Assertions.assertThat((String)((TaskSummary)taskList.get(i)).getName()).isEqualTo((Object)("john's task " + (i + 1)));
        }
        this.abortHumanTaskProcess(3);
    }

    @Test
    @BZ(value={"1132145"})
    public void testSingleResult() {
        this.startHumanTaskProcess(4, "john's task", "john");
        List taskList = this.taskService.getTasksAssignedAsPotentialOwner("john", null, null, new QueryFilter(0, 0, true));
        this.logger.info("### Potential owner task list: " + taskList);
        Assertions.assertThat((List)taskList).hasSize(1);
        this.abortHumanTaskProcess(4);
    }

    @Test
    @BZ(value={"1132157"})
    public void testFilterParams() {
        this.startHumanTaskProcess(10, "john's task", "john");
        QueryFilter queryFilter = new QueryFilter("x=1,y=2", null, "t.name", true);
        List taskList = this.taskService.getTasksAssignedAsPotentialOwner("john", null, null, queryFilter);
        this.logger.info("### Potential owner task list: " + taskList);
        Assertions.assertThat((List)taskList).hasSize(1);
        this.abortHumanTaskProcess(10);
    }

    private void startHumanTaskProcess(int instanceCount, String taskName, String assigneeName) {
        this.startHumanTaskProcess(instanceCount, taskName, assigneeName, "en-UK");
    }

    private void startHumanTaskProcess(int instanceCount, String taskName, String assigneeName, String localeName) {
        for (int i = 0; i < instanceCount; ++i) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("assigneeName", assigneeName);
            parameters.put("taskName", taskName + " " + (i + 1));
            parameters.put("localeName", localeName);
            this.instanceList.add(this.kieSession.startProcess(CONF_HUMAN_TASK_ID, parameters));
        }
    }

    private void abortHumanTaskProcess(int instanceCount) {
        for (int i = 0; i < instanceCount; ++i) {
            this.kieSession.abortProcessInstance(this.instanceList.get(i).getId());
        }
        this.instanceList = this.instanceList.subList(instanceCount, this.instanceList.size());
    }
}

