/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.jbpm.services.task.exception.PermissionDeniedException;
import org.jbpm.services.task.identity.JBossUserGroupCallbackImpl;
import org.jbpm.services.task.wih.util.LocalHTWorkItemHandlerUtil;
import org.jbpm.test.JbpmTestCase;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.UserGroupCallback;

public class LocalTaskServiceTest
extends JbpmTestCase {
    private static final String HUMAN_TASK = "org/jbpm/test/functional/common/HumanTask.bpmn2";
    private static final String HUMAN_TASK_ID = "org.jbpm.test.functional.common.HumanTask";
    private static final String USER_GROUP_RES = "classpath:/usergroups.properties";
    private static final String BUSINESS_ADMINISTRATOR = "Administrator";
    private KieSession kieSession;
    private TaskService taskService;

    public LocalTaskServiceTest() {
        super(true, true);
    }

    @Before
    public void init() throws Exception {
        this.createRuntimeManager(new String[]{HUMAN_TASK});
        RuntimeEngine re = this.getRuntimeEngine();
        this.kieSession = re.getKieSession();
        this.taskService = LocalHTWorkItemHandlerUtil.registerLocalHTWorkItemHandler((KieSession)this.kieSession, (EntityManagerFactory)this.getEmf(), (UserGroupCallback)new JBossUserGroupCallbackImpl(USER_GROUP_RES));
    }

    @Test
    public void executeTaskCompleteTest() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK_ID);
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"start", "user task"});
        List list = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        this.taskService.start(task.getId().longValue(), "john");
        this.taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"end"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    @Test(expected=PermissionDeniedException.class)
    public void executeTaskDelegationTest() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK_ID);
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"start", "user task"});
        List list = this.taskService.getTasksAssignedAsBusinessAdministrator(BUSINESS_ADMINISTRATOR, "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        this.delegateTask(task, "mary", "doctor");
    }

    @Test
    public void executeTaskDelegationByBusinessAdministratorTest() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK_ID);
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertNodeTriggered(processInstance.getId(), new String[]{"start", "user task"});
        List list = this.taskService.getTasksAssignedAsBusinessAdministrator(BUSINESS_ADMINISTRATOR, "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        this.delegateTask(task, BUSINESS_ADMINISTRATOR, "doctor");
        this.assertNodeTriggered(processInstance.getId(), new String[]{"end"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    private void delegateTask(TaskSummary task, String businessAdministrator, String delegateTo) {
        this.taskService.delegate(task.getId().longValue(), businessAdministrator, delegateTo);
        this.taskService.start(task.getId().longValue(), delegateTo);
        this.taskService.complete(task.getId().longValue(), delegateTo, null);
    }
}

