/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.HashMap;
import java.util.List;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;

public class ParalellLoopTest
extends JbpmTestCase {
    TaskService taskService;

    @Test
    public void testProcessMaryReject() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/ParalellLoopTest.bpmn"});
        RuntimeEngine engine = this.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        this.taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("hu.tsm.ParalellLoopTest");
        this.assertProcessInstanceActive(processInstance.getId());
        for (int i = 0; i < 20; ++i) {
            System.out.println(">>> Loop: " + i);
            this.assertNodeTriggered(processInstance.getId(), new String[]{"ApproveMary"});
            this.assertNodeTriggered(processInstance.getId(), new String[]{"ApproveJohn"});
            String user = "mary";
            this.complete(user, "Reject");
        }
        this.complete("john", "Approve");
        this.complete("mary", "Approve");
        this.assertProcessInstanceCompleted(processInstance.getId());
        manager.disposeRuntimeEngine(engine);
        manager.close();
    }

    @Test
    public void testProcessJohnReject() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/ParalellLoopTest.bpmn"});
        RuntimeEngine engine = this.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        this.taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("hu.tsm.ParalellLoopTest");
        this.assertProcessInstanceActive(processInstance.getId());
        for (int i = 0; i < 20; ++i) {
            System.out.println(">>> Loop: " + i);
            this.assertNodeTriggered(processInstance.getId(), new String[]{"ApproveMary"});
            this.assertNodeTriggered(processInstance.getId(), new String[]{"ApproveJohn"});
            String user = "john";
            this.complete(user, "Reject");
        }
        this.complete("john", "Approve");
        this.complete("mary", "Approve");
        this.assertProcessInstanceCompleted(processInstance.getId());
        manager.disposeRuntimeEngine(engine);
        manager.close();
    }

    @Test
    public void testProcessMaryApproveJohnReject() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/ParalellLoopTest.bpmn"});
        RuntimeEngine engine = this.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        this.taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("hu.tsm.ParalellLoopTest");
        this.assertProcessInstanceActive(processInstance.getId());
        for (int i = 0; i < 20; ++i) {
            System.out.println(">>> Loop: " + i);
            this.complete("mary", "Approve");
            this.complete("john", "Reject");
        }
        this.complete("john", "Approve");
        this.complete("mary", "Approve");
        this.assertProcessInstanceCompleted(processInstance.getId());
        manager.disposeRuntimeEngine(engine);
        manager.close();
    }

    @Test
    public void testProcessJohnApproveMaryReject() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/ParalellLoopTest.bpmn"});
        RuntimeEngine engine = this.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        this.taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("hu.tsm.ParalellLoopTest");
        this.assertProcessInstanceActive(processInstance.getId());
        for (int i = 0; i < 20; ++i) {
            System.out.println(">>> Loop: " + i);
            this.complete("john", "Approve");
            this.complete("mary", "Reject");
        }
        this.complete("john", "Approve");
        this.complete("mary", "Approve");
        this.assertProcessInstanceCompleted(processInstance.getId());
        manager.disposeRuntimeEngine(engine);
        manager.close();
    }

    @Test
    public void testProcessAlternateReject() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/ParalellLoopTest.bpmn"});
        RuntimeEngine engine = this.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        this.taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("hu.tsm.ParalellLoopTest");
        this.assertProcessInstanceActive(processInstance.getId());
        for (int i = 0; i < 20; ++i) {
            System.out.println(">>> Loop: " + i);
            this.assertNodeTriggered(processInstance.getId(), new String[]{"ApproveMary"});
            this.assertNodeTriggered(processInstance.getId(), new String[]{"ApproveJohn"});
            String user = "mary";
            boolean alternate = true;
            if (alternate && i % 2 == 1) {
                user = "john";
            }
            this.complete(user, "Reject");
        }
        this.complete("john", "Approve");
        this.complete("mary", "Approve");
        this.assertProcessInstanceCompleted(processInstance.getId());
        manager.disposeRuntimeEngine(engine);
        manager.close();
    }

    @Test
    public void testProcessMaryApproveJohnApprove() {
        RuntimeManager manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/ParalellLoopTest.bpmn"});
        RuntimeEngine engine = this.getRuntimeEngine(null);
        KieSession ksession = engine.getKieSession();
        this.taskService = engine.getTaskService();
        ProcessInstance processInstance = ksession.startProcess("hu.tsm.ParalellLoopTest");
        this.assertProcessInstanceActive(processInstance.getId());
        this.complete("john", "Approve");
        this.complete("mary", "Approve");
        this.assertProcessInstanceCompleted(processInstance.getId());
        manager.disposeRuntimeEngine(engine);
        manager.close();
    }

    private void complete(String user, String outcome) {
        List list = this.taskService.getTasksAssignedAsPotentialOwner(user, "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        System.out.println("complete task");
        System.out.println("- " + user + " is executing task " + task.getName());
        this.taskService.start(task.getId().longValue(), user);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("OUTCOME", outcome);
        this.taskService.complete(task.getId().longValue(), user, map);
        System.out.println("- " + user + " executed task " + task.getName());
    }

    public ParalellLoopTest() {
        super(true, true);
    }
}

