/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.event;

import java.util.Date;
import java.util.HashMap;
import org.drools.core.time.TimeUtils;
import org.jbpm.process.core.timer.BusinessCalendarImpl;
import org.jbpm.test.JbpmTestCase;
import org.joda.time.DateTime;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;

public class BoundaryEventOnTaskWithCalendarTest
extends JbpmTestCase {
    public BoundaryEventOnTaskWithCalendarTest() {
        super(true, true);
    }

    @Test
    public void testProcess() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/event/BoundaryEventWithCalendar.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ksession.getEnvironment().set("jbpm.business.calendar", (Object)new BusinessCalendarImpl());
        HashMap<String, String> params = new HashMap<String, String>();
        DateTime now = new DateTime(System.currentTimeMillis());
        now.plus(2000L);
        params.put("date", now.toString());
        ProcessInstance processInstance = ksession.startProcess("boundaryTimer", params);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "form1"});
        Thread.sleep(3000L);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Koniec1"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    @Test
    public void testProcessWithTimeCycleISO() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/event/BoundaryEventWithCycleCalendar.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ksession.getEnvironment().set("jbpm.business.calendar", (Object)new BusinessCalendarImpl(){

            public long calculateBusinessTimeAsDuration(String timeExpression) {
                timeExpression = this.adoptISOFormat(timeExpression);
                return TimeUtils.parseTimeString((String)timeExpression);
            }

            public Date calculateBusinessTimeAsDate(String timeExpression) {
                timeExpression = this.adoptISOFormat(timeExpression);
                return new Date(TimeUtils.parseTimeString((String)(this.getCurrentTime() + timeExpression)));
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", "R3/PT2S");
        ProcessInstance processInstance = ksession.startProcess("boundaryTimer", params);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "form1"});
        Thread.sleep(3000L);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Koniec1"});
        this.assertProcessInstanceCompleted(processInstance.getId());
    }
}

