/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.drools.core.command.runtime.process.CompleteWorkItemCommand;
import org.drools.core.command.runtime.process.RegisterWorkItemHandlerCommand;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.jbpm.workflow.instance.node.DynamicNodeInstance;
import org.jbpm.workflow.instance.node.DynamicUtils;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.CommandFactory;
import qa.tools.ikeeper.annotation.BZ;

public class AdHocSubProcessTest
extends JbpmTestCase {
    private static final String ADHOC = "org/jbpm/test/functional/subprocess/AdHocSubProcess.bpmn";
    private static final String ADHOC_ID = "org.jbpm.test.functional.subprocess.AdHocSubProcess";
    private static final String ADHOC_AUTOCOMPLETE = "org/jbpm/test/functional/subprocess/AdHocSubProcess-autocomplete.bpmn";
    private static final String ADHOC_AUTOCOMPLETE_ID = "org.jbpm.test.functional.subprocess.AdHocSubProcess-autocomplete";
    private static final String ADHOC_AUTOCOMPLETE2 = "org/jbpm/test/functional/subprocess/AdHocSubProcess-autocomplete2.bpmn";
    private static final String ADHOC_AUTOCOMPLETE2_ID = "org.jbpm.test.functional.subprocess.AdHocSubProcess-autocomplete2";

    public AdHocSubProcessTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testAdHocSubprocessDynamicWorkItem() {
        KieSession kieSession = this.createKSession(ADHOC);
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        WorkflowProcessInstance pi = (WorkflowProcessInstance)kieSession.execute(CommandFactory.newStartProcess((String)ADHOC_ID));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)ADHOC_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"start");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"adhoc");
        JbpmJUnitBaseTestCase.TestWorkItemHandler handler = this.getTestWorkItemHandler();
        RegisterWorkItemHandlerCommand registerCommand = new RegisterWorkItemHandlerCommand("addedWorkItem", (WorkItemHandler)handler);
        kieSession.execute((Command)registerCommand);
        DynamicNodeInstance dynamicNodeInstance = (DynamicNodeInstance)pi.getNodeInstances().iterator().next();
        DynamicUtils.addDynamicWorkItem((DynamicNodeInstance)dynamicNodeInstance, (KieRuntime)kieSession, (String)"addedWorkItem", new HashMap());
        WorkItem wi = handler.getWorkItem();
        CompleteWorkItemCommand completeCommand = new CompleteWorkItemCommand(wi.getId(), null);
        kieSession.execute((Command)completeCommand);
        AdHocSubProcessTest.assertEquals((Object)"addedWorkItem", (Object)wi.getName());
    }

    @BZ(value={"807187"})
    @Test(timeout=30000L)
    public void testAdHocSubprocess() {
        KieSession kieSession = this.createKSession(ADHOC);
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        ProcessInstance pi = (ProcessInstance)kieSession.execute(CommandFactory.newStartProcess((String)ADHOC_ID));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)ADHOC_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"start");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"adhoc");
        kieSession.execute(CommandFactory.newSignalEvent((long)pi.getId(), (String)"script1", null));
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"script1");
        kieSession.execute(CommandFactory.newSignalEvent((long)pi.getId(), (String)"script2", null));
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"script2");
        kieSession.execute(CommandFactory.newSignalEvent((long)pi.getId(), (String)"script3", null));
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"script3");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"innerEnd");
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)eventListener, (String)"adhoc");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)eventListener, (String)ADHOC_ID);
    }

    @Test(timeout=30000L)
    public void testAdHocSubprocessAutocomplete() {
        KieSession kieSession = this.createKSession(ADHOC_AUTOCOMPLETE);
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        TestUserWorkItemHandler handler = new TestUserWorkItemHandler();
        ArrayList<RegisterWorkItemHandlerCommand> commands = new ArrayList<RegisterWorkItemHandlerCommand>();
        commands.add(new RegisterWorkItemHandlerCommand("Human Task", (WorkItemHandler)handler));
        kieSession.execute((Command)CommandFactory.newBatchExecution(commands));
        WorkflowProcessInstance pi = (WorkflowProcessInstance)kieSession.execute(CommandFactory.newStartProcess((String)ADHOC_AUTOCOMPLETE_ID));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)ADHOC_AUTOCOMPLETE_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"start");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"adhoc");
        kieSession.execute(CommandFactory.newSignalEvent((long)pi.getId(), (String)"task1", null));
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"task1");
        kieSession.execute(CommandFactory.newSignalEvent((long)pi.getId(), (String)"task2", null));
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"task2");
        WorkItem wi1 = handler.getWorkItems().get(0);
        WorkItem wi2 = handler.getWorkItems().get(1);
        kieSession.getWorkItemManager().completeWorkItem(wi1.getId(), null);
        AdHocSubProcessTest.assertFalse((boolean)eventListener.wasNodeLeft("adhoc"));
        kieSession.getWorkItemManager().completeWorkItem(wi2.getId(), null);
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)eventListener, (String)"adhoc");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)eventListener, (String)ADHOC_AUTOCOMPLETE_ID);
    }

    @BZ(value={"808070"})
    @Test(timeout=30000L)
    public void testAdHocSubProcessAutoComplete2() {
        KieSession kieSession = this.createKSession(ADHOC_AUTOCOMPLETE2);
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        TestUserWorkItemHandler handler = new TestUserWorkItemHandler();
        kieSession.execute((Command)new RegisterWorkItemHandlerCommand("Human Task", (WorkItemHandler)handler));
        WorkflowProcessInstance pi = (WorkflowProcessInstance)kieSession.execute(CommandFactory.newStartProcess((String)ADHOC_AUTOCOMPLETE2_ID));
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)ADHOC_AUTOCOMPLETE2_ID);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"start");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"adhoc");
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newSignalEvent((long)pi.getId(), (String)"task1", null));
        commands.add(CommandFactory.newSignalEvent((long)pi.getId(), (String)"task2", null));
        kieSession.execute((Command)CommandFactory.newBatchExecution(commands));
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"task1");
        TrackingListenerAssert.assertTriggered((TrackingProcessEventListener)eventListener, (String)"task2");
        WorkItem wi = handler.getWorkItems().get(0);
        kieSession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        TrackingListenerAssert.assertLeft((TrackingProcessEventListener)eventListener, (String)"adhoc");
        TrackingListenerAssert.assertProcessCompleted((TrackingProcessEventListener)eventListener, (String)ADHOC_AUTOCOMPLETE2_ID);
    }

    class TestUserWorkItemHandler
    implements WorkItemHandler {
        List<WorkItem> workItems = new ArrayList<WorkItem>();

        TestUserWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem wi, WorkItemManager wim) {
            if (!this.workItems.contains(wi)) {
                this.workItems.add(wi);
            }
        }

        public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
        }

        public List<WorkItem> getWorkItems() {
            return this.workItems;
        }
    }
}

