/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.persistence.Persistence;
import org.drools.core.time.TimerService;
import org.jbpm.process.core.timer.TimerServiceRegistry;
import org.jbpm.process.core.timer.impl.GlobalTimerService;
import org.jbpm.process.core.timer.impl.QuartzSchedulerService;
import org.jbpm.runtime.manager.impl.AbstractRuntimeManager;
import org.jbpm.test.functional.timer.GlobalTimerServiceBaseTest;
import org.jbpm.test.functional.timer.TimerBaseTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RegisterableItemsFactory;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@RunWith(value=Parameterized.class)
public class GlobalQuartzDBTimerServiceTest
extends GlobalTimerServiceBaseTest {
    private int managerType;

    @Parameterized.Parameters
    public static Collection<Object[]> persistence() {
        Object[][] data = new Object[][]{{1}, {2}, {3}};
        return Arrays.asList(data);
    }

    public GlobalQuartzDBTimerServiceTest(int managerType) {
        this.managerType = managerType;
    }

    @Before
    public void setUp() {
        GlobalQuartzDBTimerServiceTest.cleanupSingletonSessionId();
        this.emf = Persistence.createEntityManagerFactory((String)"org.jbpm.test.persistence");
        System.setProperty("org.quartz.properties", "quartz-db.properties");
        this.testCreateQuartzSchema();
        this.globalScheduler = new QuartzSchedulerService();
        ((QuartzSchedulerService)this.globalScheduler).forceShutdown();
    }

    @After
    public void tearDown() {
        try {
            this.globalScheduler.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanup();
        System.clearProperty("org.quartz.properties");
    }

    @Override
    protected RuntimeManager getManager(RuntimeEnvironment environment, boolean waitOnStart) {
        RuntimeManager manager = null;
        if (this.managerType == 1) {
            manager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        } else if (this.managerType == 2) {
            manager = RuntimeManagerFactory.Factory.get().newPerRequestRuntimeManager(environment);
        } else if (this.managerType == 3) {
            manager = RuntimeManagerFactory.Factory.get().newPerProcessInstanceRuntimeManager(environment);
        } else {
            throw new IllegalArgumentException("Invalid runtime maanger type");
        }
        if (waitOnStart) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return manager;
    }

    @Test
    public void testTimerStartManagerClose() throws Exception {
        int badNumTimers = 4;
        final CountDownLatch timerCompleted = new CountDownLatch(badNumTimers);
        QuartzSchedulerService additionalCopy = new QuartzSchedulerService();
        additionalCopy.initScheduler(null);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void beforeProcessStarted(ProcessStartedEvent event) {
                timerExporations.add(event.getProcessInstance().getId());
                timerCompleted.countDown();
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/TimerStart2.bpmn2"), ResourceType.BPMN2).schedulerService((Object)this.globalScheduler).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, (ProcessEventListener)listener)).get();
        this.manager = this.getManager(this.environment, false);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        GlobalQuartzDBTimerServiceTest.assertEquals((long)0L, (long)timerExporations.size());
        boolean didNotWait = timerCompleted.await(3L, TimeUnit.SECONDS);
        GlobalQuartzDBTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        this.manager.disposeRuntimeEngine(runtime);
        int atDispose = timerExporations.size();
        GlobalQuartzDBTimerServiceTest.assertTrue((atDispose > 0 ? 1 : 0) != 0);
        ((AbstractRuntimeManager)this.manager).close(true);
        didNotWait = timerCompleted.await(3L, TimeUnit.SECONDS);
        GlobalQuartzDBTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        GlobalQuartzDBTimerServiceTest.assertEquals((long)atDispose, (long)timerExporations.size());
        additionalCopy.shutdown();
    }

    @Test
    @Ignore
    public void testAbortGlobalTestService() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle3.bpmn2"), ResourceType.BPMN2).addConfiguration("drools.timerService", "org.jbpm.process.core.timer.impl.RegisteredTimerServiceDelegate").get();
        RuntimeManager manger = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        GlobalTimerService globalTs = new GlobalTimerService(manger, this.globalScheduler);
        TimerServiceRegistry.getInstance().registerTimerService("default", (TimerService)globalTs);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        long id = -1L;
        Thread.sleep(5000L);
        RuntimeEngine runtime = manger.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ksession.addEventListener((ProcessEventListener)listener);
        ksession.abortProcessInstance(id);
        ProcessInstance processInstance = ksession.getProcessInstance(id);
        GlobalQuartzDBTimerServiceTest.assertNull((Object)processInstance);
        Thread.sleep(3000L);
        ksession.dispose();
    }

    @Test
    @Ignore
    public void testContinueGlobalTestService() throws Exception {
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle2.bpmn2"), ResourceType.BPMN2).addConfiguration("drools.timerService", "org.jbpm.process.core.timer.impl.RegisteredTimerServiceDelegate").get();
        RuntimeManager manger = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        GlobalTimerService globalTs = new GlobalTimerService(manger, this.globalScheduler);
        TimerServiceRegistry.getInstance().registerTimerService("default", (TimerService)globalTs);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                }
            }
        };
        Thread.sleep(5000L);
    }

    @Test
    public void testContinueTimer() throws Exception {
        int badNumTimers = 3;
        final CountDownLatch timerCompleted = new CountDownLatch(badNumTimers);
        final ArrayList timerExporations = new ArrayList();
        DefaultProcessEventListener listener = new DefaultProcessEventListener(){

            public void afterNodeLeft(ProcessNodeLeftEvent event) {
                if (event.getNodeInstance().getNodeName().equals("timer")) {
                    timerExporations.add(event.getProcessInstance().getId());
                    timerCompleted.countDown();
                }
            }
        };
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle4.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, (ProcessEventListener)listener)).get();
        this.manager = this.getManager(this.environment, true);
        RuntimeEngine runtime = this.manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("IntermediateCatchEvent");
        boolean didNotWait = timerCompleted.await(5L, TimeUnit.SECONDS);
        GlobalQuartzDBTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        GlobalQuartzDBTimerServiceTest.assertEquals((long)1L, (long)timerExporations.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
        didNotWait = timerCompleted.await(5L, TimeUnit.SECONDS);
        GlobalQuartzDBTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        this.environment = RuntimeEnvironmentBuilder.Factory.get().newDefaultBuilder().entityManagerFactory((Object)this.emf).addAsset(ResourceFactory.newClassPathResource((String)"org/jbpm/test/functional/timer/IntermediateCatchEventTimerCycle4.bpmn2"), ResourceType.BPMN2).registerableItemsFactory((RegisterableItemsFactory)new TimerBaseTest.TestRegisterableItemsFactory((TimerBaseTest)this, (ProcessEventListener)listener)).get();
        this.manager = this.getManager(this.environment, true);
        didNotWait = timerCompleted.await(2L, TimeUnit.SECONDS);
        GlobalQuartzDBTimerServiceTest.assertTrue((String)("Too many timers elapsed: " + ((long)badNumTimers - timerCompleted.getCount())), (!didNotWait ? 1 : 0) != 0);
        GlobalQuartzDBTimerServiceTest.assertEquals((long)2L, (long)timerExporations.size());
        this.manager.disposeRuntimeEngine(runtime);
        this.manager.close();
    }
}

