/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.casemgmt;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.casemgmt.CaseMgmtUtil;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.executor.impl.wih.AsyncWorkItemHandler;
import org.jbpm.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.jobexec.CheckCallCommand;
import org.junit.Test;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class AsyncCaseTest
extends JbpmTestCase {
    protected static final String TERMINATE_CASE = "org/jbpm/test/functional/casemgmt/TerminateMilestone.bpmn2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testAsyncWorkItem() {
        Object LOCK;
        ExecutorService executorService = ExecutorServiceFactory.newExecutorService();
        executorService.setThreadPoolSize(1);
        executorService.setInterval(1);
        executorService.setRetries(2);
        executorService.init();
        this.addWorkItemHandler("async", (WorkItemHandler)new AsyncWorkItemHandler(executorService));
        this.addWorkItemHandler("Milestone", (WorkItemHandler)new SystemOutWorkItemHandler());
        KieSession ksession = this.createKSession(TERMINATE_CASE);
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        CaseMgmtUtil caseMgmtService = new CaseMgmtUtil(runtimeEngine);
        ProcessInstance pi = caseMgmtService.startNewCase("AsyncWorkItem");
        long pid = pi.getId();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("CommandClass", CheckCallCommand.class.getCanonicalName());
        caseMgmtService.createDynamicWorkTask(pid, "async", params);
        Object object = LOCK = CheckCallCommand.getLOCK();
        synchronized (object) {
            try {
                LOCK.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Boolean commandExecuted = CheckCallCommand.isCommandExecuted();
        Assertions.assertThat((Boolean)commandExecuted).isTrue();
        caseMgmtService.triggerAdHocFragment(pid, "Terminate");
    }
}

