/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.jta.JtaTransactionManager;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDownProcessEventListener
extends DefaultProcessEventListener {
    private static final Logger logger = LoggerFactory.getLogger(CountDownProcessEventListener.class);
    private String nodeName;
    private CountDownLatch latch;
    private boolean reactOnBeforeNodeLeft = false;

    public CountDownProcessEventListener() {
    }

    public CountDownProcessEventListener(String nodeName, int threads) {
        this.nodeName = nodeName;
        this.latch = new CountDownLatch(threads);
    }

    public CountDownProcessEventListener(String nodeName, int threads, boolean reactOnBeforeNodeLeft) {
        this.nodeName = nodeName;
        this.latch = new CountDownLatch(threads);
        this.reactOnBeforeNodeLeft = reactOnBeforeNodeLeft;
    }

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        if (this.nodeName.equals(event.getNodeInstance().getNodeName())) {
            this.countDown();
        }
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        if (this.reactOnBeforeNodeLeft && this.nodeName.equals(event.getNodeInstance().getNodeName())) {
            this.countDown();
        }
    }

    public void waitTillCompleted() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers for node {}", (Object)this.nodeName);
        }
    }

    public void waitTillCompleted(long timeOut) {
        try {
            this.latch.await(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers for node {}", (Object)this.nodeName);
        }
    }

    public void reset(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public void reset(String nodeName, int threads) {
        this.nodeName = nodeName;
        this.latch = new CountDownLatch(threads);
    }

    protected void countDown() {
        try {
            JtaTransactionManager tm = new JtaTransactionManager(null, null, null);
            if (tm != null && tm.getStatus() != 3 && tm.getStatus() != 1 && tm.getStatus() != 0) {
                tm.registerTransactionSynchronization(new TransactionSynchronization(){

                    public void beforeCompletion() {
                    }

                    public void afterCompletion(int status) {
                        CountDownProcessEventListener.this.latch.countDown();
                    }
                });
            } else {
                this.latch.countDown();
            }
        }
        catch (Exception e) {
            this.latch.countDown();
        }
    }
}

