/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jbpm.services.task.lifecycle.listeners.TaskLifeCycleEventListener;
import org.kie.api.task.TaskEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDownTaskEventListener
implements TaskLifeCycleEventListener {
    private static final Logger logger = LoggerFactory.getLogger(CountDownTaskEventListener.class);
    private CountDownLatch latch;
    private boolean reassignmentAware;
    private boolean notificationAware;

    public CountDownTaskEventListener(int threads, boolean reassignmentAware, boolean notificationAware) {
        this.latch = new CountDownLatch(threads);
        this.reassignmentAware = reassignmentAware;
        this.notificationAware = notificationAware;
    }

    public void waitTillCompleted() {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers notification/reassignment");
        }
    }

    public void waitTillCompleted(long timeOut) {
        try {
            this.latch.await(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            logger.debug("Interrputed thread while waiting for all triggers notification/reassignment");
        }
    }

    public void reset(int threads) {
        this.latch = new CountDownLatch(threads);
    }

    public void beforeTaskActivatedEvent(TaskEvent event) {
    }

    public void beforeTaskClaimedEvent(TaskEvent event) {
    }

    public void beforeTaskSkippedEvent(TaskEvent event) {
    }

    public void beforeTaskStartedEvent(TaskEvent event) {
    }

    public void beforeTaskStoppedEvent(TaskEvent event) {
    }

    public void beforeTaskCompletedEvent(TaskEvent event) {
    }

    public void beforeTaskFailedEvent(TaskEvent event) {
    }

    public void beforeTaskAddedEvent(TaskEvent event) {
    }

    public void beforeTaskExitedEvent(TaskEvent event) {
    }

    public void beforeTaskReleasedEvent(TaskEvent event) {
    }

    public void beforeTaskResumedEvent(TaskEvent event) {
    }

    public void beforeTaskSuspendedEvent(TaskEvent event) {
    }

    public void beforeTaskForwardedEvent(TaskEvent event) {
    }

    public void beforeTaskDelegatedEvent(TaskEvent event) {
    }

    public void beforeTaskNominatedEvent(TaskEvent event) {
    }

    public void afterTaskActivatedEvent(TaskEvent event) {
    }

    public void afterTaskClaimedEvent(TaskEvent event) {
    }

    public void afterTaskSkippedEvent(TaskEvent event) {
        this.latch.countDown();
    }

    public void afterTaskStartedEvent(TaskEvent event) {
    }

    public void afterTaskStoppedEvent(TaskEvent event) {
    }

    public void afterTaskCompletedEvent(TaskEvent event) {
        this.latch.countDown();
    }

    public void afterTaskFailedEvent(TaskEvent event) {
        this.latch.countDown();
    }

    public void afterTaskAddedEvent(TaskEvent event) {
    }

    public void afterTaskExitedEvent(TaskEvent event) {
        this.latch.countDown();
    }

    public void afterTaskReleasedEvent(TaskEvent event) {
    }

    public void afterTaskResumedEvent(TaskEvent event) {
    }

    public void afterTaskSuspendedEvent(TaskEvent event) {
    }

    public void afterTaskForwardedEvent(TaskEvent event) {
    }

    public void afterTaskDelegatedEvent(TaskEvent event) {
    }

    public void afterTaskNominatedEvent(TaskEvent event) {
    }

    public void beforeTaskUpdatedEvent(TaskEvent event) {
    }

    public void afterTaskUpdatedEvent(TaskEvent event) {
    }

    public void beforeTaskReassignedEvent(TaskEvent event) {
    }

    public void afterTaskReassignedEvent(TaskEvent event) {
        if (this.reassignmentAware) {
            this.latch.countDown();
        }
    }

    public void beforeTaskNotificationEvent(TaskEvent event) {
    }

    public void afterTaskNotificationEvent(TaskEvent event) {
        if (this.notificationAware) {
            this.latch.countDown();
        }
    }
}

