/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.jbpm.services.task.admin.listener.TaskCleanUpProcessEventListener;
import org.jbpm.services.task.identity.DefaultUserInfo;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.event.KnowledgeRuntimeEventManager;
import org.kie.internal.logger.KnowledgeRuntimeLoggerFactory;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import org.kie.internal.task.api.EventService;
import org.kie.internal.task.api.InternalTaskService;
import org.kie.internal.task.api.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminAPIsWithListenerTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(AdminAPIsWithListenerTest.class);
    private EntityManagerFactory emfTasks;
    protected UserInfo userInfo;
    protected Properties conf;

    public AdminAPIsWithListenerTest() {
        super(true, true);
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.emfTasks = Persistence.createEntityManagerFactory((String)"org.jbpm.services.task");
        this.userInfo = new DefaultUserInfo(null);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.emfTasks != null && this.emfTasks.isOpen()) {
            this.emfTasks.close();
        }
    }

    @Test
    public void automaticCleanUpTest() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/patient-appointment.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)((KnowledgeRuntimeEventManager)ksession));
        ksession.addEventListener((ProcessEventListener)new TaskCleanUpProcessEventListener(taskService));
        AdminAPIsWithListenerTest.assertEquals((long)2L, (long)((EventService)taskService).getTaskEventListeners().size());
        AdminAPIsWithListenerTest.assertEquals((long)2L, (long)((EventService)taskService).getTaskEventListeners().size());
        logger.info("### Starting process ###");
        HashMap parameters = new HashMap();
        ProcessInstance process = ksession.startProcess("org.jbpm.PatientAppointment", parameters);
        Assert.assertEquals((long)1L, (long)process.getState());
        List frontDeskTasks = taskService.getTasksAssignedAsPotentialOwner("frontDesk", "en-UK");
        Assert.assertEquals((long)1L, (long)frontDeskTasks.size());
        List doctorTasks = taskService.getTasksAssignedAsPotentialOwner("doctor", "en-UK");
        Assert.assertTrue((boolean)doctorTasks.isEmpty());
        List managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertTrue((boolean)managerTasks.isEmpty());
        taskService.start(((TaskSummary)frontDeskTasks.get(0)).getId().longValue(), "frontDesk");
        taskService.complete(((TaskSummary)frontDeskTasks.get(0)).getId().longValue(), "frontDesk", null);
        doctorTasks = taskService.getTasksAssignedAsPotentialOwner("doctor", "en-UK");
        Assert.assertEquals((long)1L, (long)doctorTasks.size());
        managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertTrue((boolean)managerTasks.isEmpty());
        taskService.start(((TaskSummary)doctorTasks.get(0)).getId().longValue(), "doctor");
        taskService.complete(((TaskSummary)doctorTasks.get(0)).getId().longValue(), "doctor", null);
        managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertEquals((long)1L, (long)managerTasks.size());
        taskService.start(((TaskSummary)managerTasks.get(0)).getId().longValue(), "manager");
        taskService.complete(((TaskSummary)managerTasks.get(0)).getId().longValue(), "manager", null);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((Object)process);
        EntityManager em = this.emfTasks.createEntityManager();
        Assert.assertEquals((long)0L, (long)em.createQuery("select t from TaskImpl t").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select i from I18NTextImpl i").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_BAs").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_ExclOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_PotOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Recipients").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Stakeholders").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select c from ContentImpl c").getResultList().size());
        em.close();
    }

    @Test
    public void automaticCleanUpTestAbortProcess() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/patient-appointment.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        KnowledgeRuntimeLoggerFactory.newConsoleLogger((KnowledgeRuntimeEventManager)((KnowledgeRuntimeEventManager)ksession));
        ksession.addEventListener((ProcessEventListener)new TaskCleanUpProcessEventListener(taskService));
        logger.info("### Starting process ###");
        HashMap parameters = new HashMap();
        ProcessInstance process = ksession.startProcess("org.jbpm.PatientAppointment", parameters);
        long processInstanceId = process.getId();
        Assert.assertEquals((long)1L, (long)process.getState());
        List frontDeskTasks = taskService.getTasksAssignedAsPotentialOwner("frontDesk", "en-UK");
        Assert.assertEquals((long)1L, (long)frontDeskTasks.size());
        List doctorTasks = taskService.getTasksAssignedAsPotentialOwner("doctor", "en-UK");
        Assert.assertTrue((boolean)doctorTasks.isEmpty());
        List managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertTrue((boolean)managerTasks.isEmpty());
        taskService.start(((TaskSummary)frontDeskTasks.get(0)).getId().longValue(), "frontDesk");
        taskService.complete(((TaskSummary)frontDeskTasks.get(0)).getId().longValue(), "frontDesk", null);
        doctorTasks = taskService.getTasksAssignedAsPotentialOwner("doctor", "en-UK");
        Assert.assertEquals((long)1L, (long)doctorTasks.size());
        managerTasks = taskService.getTasksAssignedAsPotentialOwner("manager", "en-UK");
        Assert.assertTrue((boolean)managerTasks.isEmpty());
        taskService.start(((TaskSummary)doctorTasks.get(0)).getId().longValue(), "doctor");
        taskService.complete(((TaskSummary)doctorTasks.get(0)).getId().longValue(), "doctor", null);
        ksession.abortProcessInstance(processInstanceId);
        process = ksession.getProcessInstance(process.getId());
        Assert.assertNull((Object)process);
        EntityManager em = this.emfTasks.createEntityManager();
        Assert.assertEquals((long)0L, (long)em.createQuery("select t from TaskImpl t").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select i from I18NTextImpl i").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_BAs").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_ExclOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_PotOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Recipients").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Stakeholders").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select c from ContentImpl c").getResultList().size());
        em.close();
    }

    @Test
    public void automaticCleanUpWitCallActivityTest() throws Exception {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/CallActivity.bpmn2", "org/jbpm/test/functional/task/CallActivity2.bpmn2", "org/jbpm/test/functional/task/CallActivitySubProcess.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ksession.addEventListener((ProcessEventListener)new TaskCleanUpProcessEventListener(taskService));
        ProcessInstance processInstance = ksession.startProcess("ParentProcessCA");
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        AdminAPIsWithListenerTest.assertEquals((long)1L, (long)tasks.size());
        long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId, "john");
        taskService.complete(taskId, "john", null);
        this.assertProcessInstanceCompleted(processInstance.getId());
        EntityManager em = this.emfTasks.createEntityManager();
        Assert.assertEquals((long)0L, (long)em.createQuery("select t from TaskImpl t").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select i from I18NTextImpl i").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_BAs").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_ExclOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_PotOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Recipients").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Stakeholders").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select c from ContentImpl c").getResultList().size());
        em.close();
    }

    @Test
    public void automaticCleanUpForSubProcessWithSingletonStrategy() throws Exception {
        TaskCleanUpProcessEventListener taskCleanUpProcessEventListener = new TaskCleanUpProcessEventListener(null);
        this.addProcessEventListener((ProcessEventListener)taskCleanUpProcessEventListener);
        RuntimeManager manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/task/ht-main.bpmn", "org/jbpm/test/functional/task/ht-sub.bpmn"});
        RuntimeEngine runtime = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        taskCleanUpProcessEventListener.setTaskService((InternalTaskService)runtime.getTaskService());
        KieSession ksession = runtime.getKieSession();
        HashMap params = new HashMap();
        ProcessInstance pi = ksession.startProcess("com.mycompany.sample", params);
        TaskService taskService = runtime.getTaskService();
        List tasks1 = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        AdminAPIsWithListenerTest.assertFalse((boolean)tasks1.isEmpty());
        TaskSummary task1 = (TaskSummary)tasks1.get(0);
        System.out.println("Sales-rep executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
        taskService.start(task1.getId().longValue(), "john");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("comment", "Agreed, existing laptop needs replacing");
        results.put("outcome", "Accept");
        taskService.complete(task1.getId().longValue(), "john", results);
        ksession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findProcessInstances("com.mycompany.sample");
        AdminAPIsWithListenerTest.assertNotNull((Object)logs);
        AdminAPIsWithListenerTest.assertEquals((long)1L, (long)logs.size());
        AdminAPIsWithListenerTest.assertEquals((long)3L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        logs = logService.findProcessInstances("com.mycompany.sample.subprocess");
        AdminAPIsWithListenerTest.assertNotNull((Object)logs);
        AdminAPIsWithListenerTest.assertEquals((long)1L, (long)logs.size());
        AdminAPIsWithListenerTest.assertEquals((long)3L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        manager.close();
        EntityManager em = this.emfTasks.createEntityManager();
        Assert.assertEquals((long)0L, (long)em.createQuery("select t from TaskImpl t").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select i from I18NTextImpl i").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_BAs").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_ExclOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_PotOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Recipients").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Stakeholders").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select c from ContentImpl c").getResultList().size());
        em.close();
    }

    @Test
    public void automaticCleanUpForSubProcessWithPerProcessInstanceStrategy() throws Exception {
        TaskCleanUpProcessEventListener taskCleanUpProcessEventListener = new TaskCleanUpProcessEventListener(null);
        this.addProcessEventListener((ProcessEventListener)taskCleanUpProcessEventListener);
        RuntimeManager manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "com.mycompany.sample", new String[]{"org/jbpm/test/functional/task/ht-main.bpmn", "org/jbpm/test/functional/task/ht-sub.bpmn"});
        RuntimeEngine runtime = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        taskCleanUpProcessEventListener.setTaskService((InternalTaskService)runtime.getTaskService());
        KieSession ksession = runtime.getKieSession();
        HashMap params = new HashMap();
        ProcessInstance pi = ksession.startProcess("com.mycompany.sample", params);
        TaskService taskService = runtime.getTaskService();
        List tasks1 = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        AdminAPIsWithListenerTest.assertFalse((boolean)tasks1.isEmpty());
        TaskSummary task1 = (TaskSummary)tasks1.get(0);
        System.out.println("Sales-rep executing task " + task1.getName() + "(" + task1.getId() + ": " + task1.getDescription() + ")");
        taskService.start(task1.getId().longValue(), "john");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("comment", "Agreed, existing laptop needs replacing");
        results.put("outcome", "Accept");
        taskService.complete(task1.getId().longValue(), "john", results);
        ksession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
        AuditService logService = runtime.getAuditService();
        List logs = logService.findProcessInstances("com.mycompany.sample");
        AdminAPIsWithListenerTest.assertNotNull((Object)logs);
        AdminAPIsWithListenerTest.assertEquals((long)1L, (long)logs.size());
        AdminAPIsWithListenerTest.assertEquals((long)3L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        logs = logService.findProcessInstances("com.mycompany.sample.subprocess");
        AdminAPIsWithListenerTest.assertNotNull((Object)logs);
        AdminAPIsWithListenerTest.assertEquals((long)1L, (long)logs.size());
        AdminAPIsWithListenerTest.assertEquals((long)3L, (long)((ProcessInstanceLog)logs.get(0)).getStatus().intValue());
        manager.close();
        EntityManager em = this.emfTasks.createEntityManager();
        Assert.assertEquals((long)0L, (long)em.createQuery("select t from TaskImpl t").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select i from I18NTextImpl i").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_BAs").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_ExclOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_PotOwners").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Recipients").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createNativeQuery("select * from PeopleAssignments_Stakeholders").getResultList().size());
        Assert.assertEquals((long)0L, (long)em.createQuery("select c from ContentImpl c").getResultList().size());
        em.close();
    }
}

