/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;
import qa.tools.ikeeper.annotation.BZ;

@BZ(value={"852738"})
public class SessionIsolationTest
extends JbpmTestCase {
    private static final String SIGNAL = "org/jbpm/test/regression/SessionIsolation-signal.bpmn";
    private static final String SIGNAL_ID = "org.jbpm.test.regression.SessionIsolation-signal";
    private static final String RULE_TASK = "org/jbpm/test/regression/SessionIsolation-ruleTask.bpmn";
    private static final String RULE_TASK_ID = "org.jbpm.test.regression.SessionIsolation-ruleTask";
    private static final String RULE_TASK_DRL = "org/jbpm/test/regression/SessionIsolation-ruleTask.drl";

    public SessionIsolationTest() {
        super(false);
    }

    @Test
    public void testSignal() throws Exception {
        this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, SIGNAL_ID, new String[]{SIGNAL});
        RuntimeEngine runtime1 = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        RuntimeEngine runtime2 = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        KieSession ksession2 = runtime2.getKieSession();
        Assertions.assertThat((Object)ksession1).isNotEqualTo((Object)ksession2);
        ProcessInstance pi1 = ksession1.startProcess(SIGNAL_ID);
        ProcessInstance pi2 = ksession2.startProcess(SIGNAL_ID);
        this.assertProcessInstanceActive(pi1.getId(), ksession1);
        this.assertProcessInstanceActive(pi2.getId(), ksession2);
        ksession1.signalEvent("event", null);
        this.assertProcessInstanceNotActive(pi1.getId(), ksession1);
        this.assertProcessInstanceActive(pi2.getId(), ksession2);
        ksession2.signalEvent("event", null);
        this.assertProcessInstanceNotActive(pi1.getId(), ksession1);
        this.assertProcessInstanceNotActive(pi2.getId(), ksession2);
    }

    @Test
    public void testRuleTask() throws Exception {
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(RULE_TASK, ResourceType.BPMN2);
        res.put(RULE_TASK_DRL, ResourceType.DRL);
        this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, res, RULE_TASK_ID);
        RuntimeEngine runtime1 = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        RuntimeEngine runtime2 = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession1 = runtime1.getKieSession();
        KieSession ksession2 = runtime2.getKieSession();
        Assertions.assertThat((Object)ksession1).isNotEqualTo((Object)ksession2);
        ProcessInstance pi1 = ksession1.startProcess(RULE_TASK_ID);
        ProcessInstance pi2 = ksession2.startProcess(RULE_TASK_ID);
        this.assertProcessInstanceActive(pi1.getId(), ksession1);
        this.assertProcessInstanceActive(pi2.getId(), ksession2);
        ksession1.fireAllRules();
        this.assertProcessInstanceNotActive(pi1.getId(), ksession1);
        this.assertProcessInstanceActive(pi2.getId(), ksession2);
        ksession2.fireAllRules();
        this.assertProcessInstanceNotActive(pi1.getId(), ksession1);
        this.assertProcessInstanceNotActive(pi2.getId(), ksession2);
    }
}

