/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.jbpm.test.listener.TrackingAgendaEventListener;
import org.junit.Test;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;

public class FireUntilHaltTest
extends JbpmTestCase {
    private static final String PROCESS = "org/jbpm/test/functional/FireUntilHalt.bpmn";
    private static final String PROCESS_ID = "org.jbpm.test.functional.FireUntilHalt";
    private static final String PROCESS_DRL = "org/jbpm/test/functional/FireUntilHalt.drl";

    public FireUntilHaltTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testFireUntilHaltWithProcess() throws Exception {
        Person p;
        int i;
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(PROCESS, ResourceType.BPMN2);
        res.put(PROCESS_DRL, ResourceType.DRL);
        final KieSession ksession = this.createKSession(res);
        ksession.getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)true);
        TrackingAgendaEventListener listener = new TrackingAgendaEventListener();
        ksession.addEventListener((AgendaEventListener)listener);
        ExecutorService thread = Executors.newSingleThreadExecutor();
        thread.submit(new Runnable(){

            @Override
            public void run() {
                ksession.fireUntilHalt();
            }
        });
        int wantedPersonsNum = 3;
        int unwantedPersonsNum = 2;
        for (i = 0; i < wantedPersonsNum; ++i) {
            p = new Person("wanted person");
            p.setId(i);
            ksession.insert((Object)p);
        }
        for (i = 0; i < unwantedPersonsNum; ++i) {
            p = new Person("unwanted person");
            p.setId(i);
            ksession.insert((Object)p);
        }
        Thread.sleep(100L);
        Assertions.assertThat((int)listener.ruleFiredCount("person detector")).isEqualTo(wantedPersonsNum + unwantedPersonsNum);
        ksession.startProcess(PROCESS_ID);
        Thread.sleep(100L);
        Assertions.assertThat((int)listener.ruleFiredCount("initial actions")).isEqualTo(1);
        Assertions.assertThat((int)listener.ruleFiredCount("wanted person detector")).isEqualTo(wantedPersonsNum);
        Assertions.assertThat((int)listener.ruleFiredCount("change unwanted person to wanted")).isEqualTo(unwantedPersonsNum);
        Assertions.assertThat((int)listener.ruleFiredCount("person detector")).isEqualTo(wantedPersonsNum + 2 * unwantedPersonsNum + 1);
        Assertions.assertThat((int)listener.ruleFiredCount("closing actions")).isEqualTo(1);
        ksession.halt();
    }
}

