/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jpa;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.drools.core.marshalling.impl.ClassObjectMarshallingStrategyAcceptor;
import org.drools.core.marshalling.impl.SerializablePlaceholderResolverStrategy;
import org.drools.persistence.jpa.marshaller.JPAPlaceholderResolverStrategy;
import org.jbpm.services.task.impl.command.CommandBasedTaskService;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.entity.Application;
import org.jbpm.test.entity.Person;
import org.junit.Test;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyAcceptor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class ParentChildMarshallingJpaTest
extends JbpmTestCase {
    private EntityManagerFactory emfDomain;

    public ParentChildMarshallingJpaTest() {
        super(true, true);
    }

    @Test
    public void testProcess() throws Exception {
        this.emfDomain = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.parent-child");
        this.addEnvironmentEntry("org.kie.api.marshalling.ObjectMarshallingStrategies", new ObjectMarshallingStrategy[]{new JPAPlaceholderResolverStrategy(this.emfDomain), new SerializablePlaceholderResolverStrategy((ObjectMarshallingStrategyAcceptor)ClassObjectMarshallingStrategyAcceptor.DEFAULT)});
        RuntimeManager manager = this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, "manager", new String[]{"org/jbpm/test/functional/jpa/parent-child.bpmn"});
        RuntimeEngine runtime = manager.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtime.getKieSession();
        HashMap<String, Application> params = new HashMap<String, Application>();
        Application application = new Application();
        application.setType("A");
        params.put("application", application);
        ProcessInstance pi = ksession.startProcess("com.sample.bpmn.hello", params);
        System.out.println("A process instance started : pid = " + pi.getId());
        TaskService taskService = runtime.getTaskService();
        ParentChildMarshallingJpaTest.assertTrue((boolean)(taskService instanceof CommandBasedTaskService));
        ParentChildMarshallingJpaTest.assertTrue((((CommandBasedTaskService)taskService).getEnvironment().get("org.kie.api.marshalling.ObjectMarshallingStrategies") != null ? 1 : 0) != 0);
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        for (TaskSummary taskSummary : list) {
            System.out.println("john starts a task : taskId = " + taskSummary.getId());
            Task task = taskService.getTaskById(taskSummary.getId().longValue());
            long documentContentId = task.getTaskData().getDocumentContentId();
            Content content = taskService.getContentById(documentContentId);
            HashMap contents = (HashMap)ContentMarshallerHelper.unmarshall((byte[])content.getContent(), (Environment)ksession.getEnvironment());
            Application outputApplication = (Application)contents.get("input1_application");
            Person person = new Person();
            person.setFullName("John Doe");
            outputApplication.setPerson(person);
            LinkedHashMap<String, Application> results = new LinkedHashMap<String, Application>();
            results.put("output1_application", outputApplication);
            taskService.start(taskSummary.getId().longValue(), "john");
            taskService.complete(taskSummary.getId().longValue(), "john", results);
        }
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        for (TaskSummary taskSummary : list) {
            System.out.println("mary starts a task : taskId = " + taskSummary.getId());
            taskService.start(taskSummary.getId().longValue(), "mary");
            taskService.complete(taskSummary.getId().longValue(), "mary", null);
        }
        manager.disposeRuntimeEngine(runtime);
        EntityManager em = this.emfDomain.createEntityManager();
        int size = em.createQuery("select i from Person i").getResultList().size();
        ParentChildMarshallingJpaTest.assertEquals((long)1L, (long)size);
    }
}

