/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.jbpm.runtime.manager.impl.task.SynchronizedTaskService;
import org.jbpm.test.JbpmTestCase;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import org.kie.api.task.model.TaskSummary;

public class TaskSubjectAndDescriptionTest
extends JbpmTestCase {
    private static final String EXPECTED_SUBJECT = "Bake a cake";
    private static final String HUMAN_TASK = "org/jbpm/test/functional/task/TaskSubjectAndDescription.bpmn2";
    private static final String HUMAN_TASK_ID = "org.jbpm.test.functional.task.TaskSubjectAndDescription";
    private static final String HUMAN_TASK2 = "org/jbpm/test/functional/task/TaskSubject.bpmn2";
    private static final String HUMAN_TASK2_ID = "org.jbpm.test.functional.task.TaskSubject";
    private KieSession kieSession;
    private TaskService taskService;

    public TaskSubjectAndDescriptionTest() {
        super(true, true);
    }

    @Before
    public void init() throws Exception {
        this.createRuntimeManager(new String[]{HUMAN_TASK, HUMAN_TASK2});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        this.kieSession = runtimeEngine.getKieSession();
        this.taskService = (SynchronizedTaskService)runtimeEngine.getTaskService();
    }

    @Test
    public void testSubjectAndDescriptionProperties() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK_ID);
        List list = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        Task t = this.taskService.getTaskById(task.getId().longValue());
        Assertions.assertThat((String)task.getDescription()).isEqualTo((Object)"This is description of the human task.");
        Assertions.assertThat((String)task.getSubject()).isNullOrEmpty();
        Assertions.assertThat((String)t.getSubject()).isEqualTo((Object)EXPECTED_SUBJECT);
        this.taskService.start(task.getId().longValue(), "john");
        this.taskService.complete(task.getId().longValue(), "john", null);
        ProcessInstanceLog plog = this.getLogService().findProcessInstance(processInstance.getId());
        Assertions.assertThat((Integer)plog.getStatus()).isEqualTo(2);
    }

    @Test
    public void testSubjectProperty() {
        ProcessInstance processInstance = this.kieSession.startProcess(HUMAN_TASK2_ID);
        List list = this.taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        Task t = this.taskService.getTaskById(task.getId().longValue());
        Assertions.assertThat((String)task.getDescription()).isEqualTo((Object)EXPECTED_SUBJECT);
        Assertions.assertThat((String)task.getSubject()).isNullOrEmpty();
        Assertions.assertThat((String)t.getSubject()).isEqualTo((Object)EXPECTED_SUBJECT);
        this.taskService.start(task.getId().longValue(), "john");
        this.taskService.complete(task.getId().longValue(), "john", null);
        ProcessInstanceLog plog = this.getLogService().findProcessInstance(processInstance.getId());
        Assertions.assertThat((Integer)plog.getStatus()).isEqualTo(2);
    }
}

