/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional;

import java.util.HashMap;
import org.drools.core.command.runtime.process.StartProcessCommand;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;

public class DataObjectTest
extends JbpmTestCase {
    public static final String PROCESS = "org/jbpm/test/functional/DataObject.bpmn";
    public static final String PROCESS_ID = "org.jbpm.test.functional.DataObject";

    public DataObjectTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testDataObject() {
        KieSession ksession = this.createKSession(PROCESS);
        IterableProcessEventListener listener = new IterableProcessEventListener();
        ksession.addEventListener((ProcessEventListener)listener);
        HashMap<String, Person> params = new HashMap<String, Person>();
        Person mojmir = new Person("Mojmir");
        params.put("person", mojmir);
        JbpmJUnitBaseTestCase.TestWorkItemHandler wih = this.getTestWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)wih);
        StartProcessCommand spc = new StartProcessCommand();
        spc.setProcessId(PROCESS_ID);
        spc.setParameters(params);
        ksession.execute((Command)spc);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)listener, (String)"person", null, (Object)mojmir);
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)listener, (String)PROCESS_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)listener, (String)"userTask");
        WorkItem wi = wih.getWorkItem();
        DataObjectTest.assertTrue((boolean)wi.getParameters().containsKey("PersonInput"));
        Object param = wi.getParameter("PersonInput");
        DataObjectTest.assertTrue((boolean)(param instanceof Person));
        Person userTaskInput = (Person)param;
        DataObjectTest.assertEquals((Object)"Mojmir", (Object)userTaskInput.getName());
        listener.clear();
        ksession.getWorkItemManager().completeWorkItem(wi.getId(), null);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)listener, (String)"userTask");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)listener, (String)PROCESS_ID);
    }
}

