/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.process.core.async.AsyncSignalEventCommand;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.wih.FirstErrorWorkItemHandler;
import org.jbpm.workflow.instance.WorkflowRuntimeException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.CommandContext;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class AsyncIntermediateCatchSignalTest
extends JbpmTestCase {
    private static Object LOCK = new Object();
    private static final String PROCESS_AICS = "org.jbpm.test.functional.async.AsyncIntermediateCatchSignal";
    private static final String BPMN_AICS = "org/jbpm/test/functional/async/AsyncIntermediateCatchSignal.bpmn2";
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.setThreadPoolSize(3);
        this.executorService.init();
        this.addEnvironmentEntry("ExecutorService", this.executorService);
        this.addWorkItemHandler("SyncError", (WorkItemHandler)new FirstErrorWorkItemHandler());
        this.addProcessEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterProcessCompleted(ProcessCompletedEvent event) {
                Object object = LOCK;
                synchronized (object) {
                    LOCK.notifyAll();
                }
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCorrectProcessStateAfterExceptionSignalCommand() {
        RuntimeManager runtimeManager = this.createRuntimeManager(new String[]{BPMN_AICS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        ProcessInstance pi = ksession.startProcess(PROCESS_AICS, null);
        long pid = pi.getId();
        CommandContext ctx = new CommandContext();
        ctx.setData("DeploymentId", (Object)runtimeManager.getIdentifier());
        ctx.setData("ProcessInstanceId", (Object)pid);
        ctx.setData("Signal", (Object)"MySignal");
        ctx.setData("Event", null);
        this.executorService.scheduleRequest(AsyncSignalEventCommand.class.getName(), ctx);
        Object object = LOCK;
        synchronized (object) {
            try {
                LOCK.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrectProcessStateAfterExceptionSignalCommandMulti() {
        int i;
        RuntimeManager runtimeManager = this.createRuntimeManager(new String[]{BPMN_AICS});
        KieSession ksession = this.getRuntimeEngine().getKieSession();
        long[] pid = new long[5];
        for (i = 0; i < 5; ++i) {
            ProcessInstance pi = ksession.startProcess(PROCESS_AICS, null);
            pid[i] = pi.getId();
            CommandContext ctx = new CommandContext();
            ctx.setData("DeploymentId", (Object)runtimeManager.getIdentifier());
            ctx.setData("ProcessInstanceId", (Object)pid[i]);
            ctx.setData("Signal", (Object)"MySignal");
            ctx.setData("Event", null);
            this.executorService.scheduleRequest(AsyncSignalEventCommand.class.getName(), ctx);
        }
        for (i = 0; i < 5; ++i) {
            Object object = LOCK;
            synchronized (object) {
                try {
                    LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        for (long p : pid) {
            ProcessInstance pi = ksession.getProcessInstance(p);
            Assertions.assertThat((Object)pi).isNull();
        }
    }

    @Test(expected=WorkflowRuntimeException.class)
    public void testSyncGlobalSignal() {
        KieSession ksession = this.createKSession(BPMN_AICS);
        ksession.startProcess(PROCESS_AICS, null);
        ksession.signalEvent("MySignal", null);
    }
}

