/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression;

import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.jbpm.test.JbpmTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;

public class ListenersTest
extends JbpmTestCase {
    private static final ReleaseId RELEASE_ID = KieServices.Factory.get().newReleaseId("org.jbpm.test", "listeners-test", "1.0.0");
    private KieServices ks = KieServices.Factory.get();
    private KieSession kieSession;

    public ListenersTest() {
        super(false, false);
    }

    @Before
    public void init() {
        ReleaseId kieModuleId = this.prepareKieModule();
        KieContainer kieContainer = this.ks.newKieContainer(kieModuleId);
        Properties properties = new Properties();
        properties.setProperty("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName());
        properties.setProperty("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName());
        this.kieSession = kieContainer.newKieSession((Environment)null, this.ks.newKieSessionConfiguration(properties));
    }

    @After
    public void cleanup() {
        if (this.kieSession != null) {
            this.kieSession.dispose();
        }
    }

    @Test
    public void testRegisterProcessEventListenerStateful() throws Exception {
        this.kieSession.startProcess("testProcess");
        Collection listeners = this.kieSession.getProcessEventListeners();
        ListenersTest.assertTrue((String)"Listener not registered.", (listeners.size() >= 1 ? 1 : 0) != 0);
        MarkingProcessEventListener listener = this.getMarkingListener(listeners);
        ListenersTest.assertTrue((String)"Expected listener to fire.", (boolean)listener.hasFired());
    }

    private MarkingProcessEventListener getMarkingListener(Collection<?> listeners) {
        for (Object listener : listeners) {
            if (!(listener instanceof MarkingProcessEventListener)) continue;
            return (MarkingProcessEventListener)((Object)listener);
        }
        throw new IllegalArgumentException("Expected at least one MarkingProcessEventListener in the collection");
    }

    private ReleaseId prepareKieModule() {
        KieServices ks = KieServices.Factory.get();
        KieModuleModel module = ks.newKieModuleModel();
        KieBaseModel baseModel = module.newKieBaseModel("defaultKBase");
        baseModel.setDefault(true);
        baseModel.addPackage("*");
        KieSessionModel sessionModel = baseModel.newKieSessionModel("defaultKSession");
        sessionModel.setDefault(true);
        sessionModel.setType(KieSessionModel.KieSessionType.STATEFUL);
        sessionModel.newListenerModel(MarkingProcessEventListener.class.getName(), ListenerModel.Kind.PROCESS_EVENT_LISTENER);
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(module.toXML());
        kfs.generateAndWritePomXML(RELEASE_ID);
        kfs.write(ResourceFactory.newClassPathResource((String)"listeners-test.bpmn", ((Object)((Object)this)).getClass()));
        KieBuilder builder = ks.newKieBuilder(kfs).buildAll();
        ListenersTest.assertEquals((String)"Unexpected compilation errors", (long)0L, (long)builder.getResults().getMessages().size());
        ks.getRepository().addKieModule(builder.getKieModule());
        return RELEASE_ID;
    }

    public static class MarkingProcessEventListener
    extends DefaultProcessEventListener {
        private final AtomicBoolean fired = new AtomicBoolean(false);

        public void beforeProcessStarted(ProcessStartedEvent event) {
            super.beforeProcessStarted(event);
            this.fired.compareAndSet(false, true);
        }

        public boolean hasFired() {
            return this.fired.get();
        }
    }
}

