/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.log;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.ProcessInstanceLogQueryBuilder;
import qa.tools.ikeeper.annotation.BZ;

public class ProcessInstanceLogCleanTest
extends JbpmTestCase {
    private static final String HELLO_WORLD_PROCESS = "org/jbpm/test/functional/common/HelloWorldProcess1.bpmn";
    private static final String HELLO_WORLD_PROCESS_ID = "org.jbpm.test.functional.common.HelloWorldProcess1";
    private static final String HELLO_WORLD_PROCESS2 = "org/jbpm/test/functional/common/HelloWorldProcess2.bpmn";
    private static final String HELLO_WORLD_PROCESS2_ID = "org.jbpm.test.functional.common.HelloWorldProcess2";
    private static final String PARENT_PROCESS_INFO = "org/jbpm/test/functional/common/ParentProcessInfo.bpmn2";
    private static final String PARENT_PROCESS_INFO_ID = "org.jbpm.test.functional.common.ParentProcessInfo";
    private static final String PARENT_PROCESS_CALLER = "org/jbpm/test/functional/common/ParentProcessInfo-Caller.bpmn2";
    private static final String PARENT_PROCESS_CALLER_ID = "org.jbpm.test.functional.common.ParentProcessInfo-Caller";
    private static final String HUMAN_TASK = "org/jbpm/test/functional/common/HumanTask.bpmn2";
    private static final String HUMAN_TASK_ID = "org.jbpm.test.functional.common.HumanTask";
    private static final String HELLO_WORLD_P1NAME = "HelloWorldProcess1";
    private static final String HELLO_WORLD_P2NAME = "HelloWorldProcess2";
    private JPAAuditLogService auditService;

    public void setUp() throws Exception {
        super.setUp();
        this.auditService = new JPAAuditLogService(this.getEmf());
        this.auditService.clear();
    }

    public void tearDown() throws Exception {
        try {
            this.auditService.clear();
            this.auditService.dispose();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void deleteLogsByProcessName() {
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 2);
        List resultList = ((ProcessInstanceLogQueryBuilder)this.auditService.processInstanceLogQuery().processId(new String[]{HELLO_WORLD_PROCESS_ID})).processVersion(new String[]{"1.0"}).build().getResultList();
        Assertions.assertThat((List)resultList).hasSize(2);
        Assertions.assertThat((List)resultList).extracting("processName").containsExactly(new Object[]{HELLO_WORLD_P1NAME, HELLO_WORLD_P1NAME});
        int resultCount = this.auditService.processInstanceLogDelete().processName(new String[]{HELLO_WORLD_P1NAME}).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(2);
        resultList = ((ProcessInstanceLogQueryBuilder)this.auditService.processInstanceLogQuery().processId(new String[]{HELLO_WORLD_PROCESS_ID})).processVersion(new String[]{"1.0"}).build().getResultList();
        Assertions.assertThat((List)resultList).hasSize(0);
    }

    @Test
    public void deleteLogsByProcessId() {
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 3);
        List resultList = this.auditService.processInstanceLogQuery().processName(new String[]{HELLO_WORLD_P1NAME}).processVersion(new String[]{"1.0"}).build().getResultList();
        Assertions.assertThat((List)resultList).hasSize(3);
        Assertions.assertThat((List)resultList).extracting("processId").containsExactly(new Object[]{HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID});
        int resultCount = ((ProcessInstanceLogDeleteBuilder)this.auditService.processInstanceLogDelete().processId(new String[]{HELLO_WORLD_PROCESS_ID})).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(3);
        resultList = this.auditService.processInstanceLogQuery().processName(new String[]{HELLO_WORLD_P1NAME}).processVersion(new String[]{"1.0"}).build().getResultList();
        Assertions.assertThat((List)resultList).hasSize(0);
    }

    @Test
    public void deleteLogsByVersion() {
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 7);
        this.disposeRuntimeManager();
        kieSession = this.createKSession(HELLO_WORLD_PROCESS2);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS2_ID, 2);
        ProcessInstanceLogDeleteBuilder deleteBuilder = this.auditService.processInstanceLogDelete().processVersion(new String[]{"1.0"});
        int deleteResult = deleteBuilder.build().execute();
        Assertions.assertThat((int)deleteResult).isEqualTo(7);
        List resultList = this.auditService.processInstanceLogQuery().processVersion(new String[]{"1.0"}).build().getResultList();
        Assertions.assertThat((List)resultList).hasSize(0);
        resultList = this.auditService.processInstanceLogQuery().processVersion(new String[]{"1.1"}).build().getResultList();
        Assertions.assertThat((List)resultList).hasSize(2);
        Assertions.assertThat((List)resultList).extracting("processVersion").containsExactly(new Object[]{"1.1", "1.1"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Test
    public void deleteLogsWithStatusActive() {
        KieSession kieSession = null;
        List<ProcessInstance> instanceList1 = null;
        List<ProcessInstance> instanceList2 = null;
        try {
            kieSession = this.createKSession(HELLO_WORLD_PROCESS, HUMAN_TASK);
            instanceList1 = this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 3);
            instanceList2 = this.startProcess(kieSession, HUMAN_TASK_ID, 5);
            ProcessInstanceLogDeleteBuilder deleteBuilder = this.auditService.processInstanceLogDelete().status(new int[]{1});
            int deleteResult = deleteBuilder.build().execute();
            Assertions.assertThat((int)deleteResult).isEqualTo(5);
            ProcessInstanceLogQueryBuilder queryBuilder = this.auditService.processInstanceLogQuery().status(new int[]{2});
            List queryList = queryBuilder.build().getResultList();
            Assertions.assertThat((List)queryList).hasSize(3);
            Assertions.assertThat((List)queryList).extracting("processId").containsExactly(new Object[]{HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID});
            Assertions.assertThat((List)queryList).extracting("processVersion").containsExactly(new Object[]{"1.0", "1.0", "1.0"});
            Assertions.assertThat((List)queryList).extracting("status").containsExactly(new Object[]{2, 2, 2});
            if (instanceList2 != null) {
                this.abortProcess(kieSession, instanceList2);
            }
            if (kieSession == null) return;
        }
        catch (Throwable throwable) {
            if (instanceList2 != null) {
                this.abortProcess(kieSession, instanceList2);
            }
            if (kieSession == null) throw throwable;
            kieSession.dispose();
            throw throwable;
        }
        kieSession.dispose();
    }

    @Test
    @BZ(value={"1188702"})
    public void deleteLogsByDate() {
        Date testStartDate = new Date();
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 4);
        List resultList = this.auditService.processInstanceLogQuery().startDateRangeStart(testStartDate).build().getResultList();
        ((AbstractListAssert)Assertions.assertThat((List)resultList).hasSize(4)).extracting("processId").containsExactly(new Object[]{HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID});
        for (int i = resultList.size() - 1; i > 0; --i) {
            int resultCount = this.auditService.processInstanceLogDelete().startDate(new Date[]{((ProcessInstanceLog)resultList.get(i)).getStart()}).build().execute();
            Assertions.assertThat((int)resultCount).isEqualTo(1);
        }
        int resultCount = this.auditService.processInstanceLogDelete().startDate(new Date[]{new Date()}).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(0);
        List resultList2 = this.auditService.processInstanceLogQuery().startDateRangeStart(testStartDate).build().getResultList();
        Assertions.assertThat((List)resultList2).hasSize(1);
        Assertions.assertThat(resultList2.get(0)).isEqualTo(resultList.get(0));
    }

    @Test
    @BZ(value={"1192498"})
    public void deleteLogsByDateRange() throws InterruptedException {
        KieSession kieSession = this.createKSession(PARENT_PROCESS_CALLER, PARENT_PROCESS_INFO, HELLO_WORLD_PROCESS);
        Date date1 = new Date();
        this.startProcess(kieSession, PARENT_PROCESS_CALLER_ID, 4);
        Date date2 = new Date();
        Thread.sleep(1000L);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 2);
        Date date3 = new Date();
        int beforeSize = this.getProcessInstanceLogSize(this.getYesterday(), this.getTomorrow());
        Assertions.assertThat((int)beforeSize).isEqualTo(10);
        int resultCount = this.auditService.processInstanceLogDelete().startDateRangeStart(date1).startDateRangeEnd(date2).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(8);
        List resultList = this.auditService.processInstanceLogQuery().startDateRangeEnd(date3).build().getResultList();
        ((AbstractListAssert)Assertions.assertThat((List)resultList).hasSize(2)).extracting("processId").containsExactly(new Object[]{HELLO_WORLD_PROCESS_ID, HELLO_WORLD_PROCESS_ID});
        int afterSize = this.getProcessInstanceLogSize(date1, date3);
        Assertions.assertThat((int)afterSize).isEqualTo(2);
    }

    @Test
    @BZ(value={"1192498"})
    public void deleteLogsByDateRangeEndingYesterday() {
        this.deleteLogsByDateRange(this.getYesterday(), this.getYesterday(), false);
    }

    @Test
    @BZ(value={"1192498"})
    public void deleteLogsByDateRangeIncludingToday() {
        this.deleteLogsByDateRange(this.getYesterday(), this.getTomorrow(), true);
    }

    @Test
    @BZ(value={"1192498"})
    public void deleteLogsByDateRangeStartingTomorrow() {
        this.deleteLogsByDateRange(this.getTomorrow(), this.getTomorrow(), false);
    }

    private void deleteLogsByDateRange(Date startDate, Date endDate, boolean expectRemoval) {
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 2);
        int beforeSize = this.getProcessInstanceLogSize(this.getYesterday(), this.getTomorrow());
        Assertions.assertThat((int)beforeSize).isEqualTo(2);
        int resultCount = this.auditService.processInstanceLogDelete().startDateRangeStart(startDate).startDateRangeEnd(endDate).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(expectRemoval ? 2 : 0);
        int afterSize = this.getProcessInstanceLogSize(this.getYesterday(), this.getTomorrow());
        Assertions.assertThat((int)afterSize).isEqualTo(expectRemoval ? 0 : 2);
    }

    private int getProcessInstanceLogSize(Date startDateRangeStart, Date startDateRangeEnd) {
        return this.auditService.processInstanceLogQuery().startDateRangeStart(startDateRangeStart).startDateRangeEnd(startDateRangeEnd).build().getResultList().size();
    }

    private Date getTomorrow() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, 1);
        return c.getTime();
    }

    private Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        return c.getTime();
    }

    private void abortProcess(KieSession kieSession, List<ProcessInstance> processInstanceList) {
        for (ProcessInstance processInstance : processInstanceList) {
            this.abortProcess(kieSession, processInstance.getId());
        }
    }

    private void abortProcess(KieSession kieSession, long pid) {
        ProcessInstance processInstance = kieSession.getProcessInstance(pid);
        if (processInstance != null && processInstance.getState() == 1) {
            kieSession.abortProcessInstance(pid);
        }
    }

    private List<ProcessInstance> startProcess(KieSession kieSession, String processId, int count) {
        ArrayList<ProcessInstance> piList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance pi = kieSession.startProcess(processId);
            if (pi == null) continue;
            piList.add(pi);
        }
        return piList;
    }
}

