/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.jpa;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.task.api.InternalTaskService;

public class SupportProcessTest
extends JbpmTestCase {
    public SupportProcessTest() {
        super(true, true);
    }

    @Test
    public void simpleSupportProcessTest() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/jpa/support.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("customer", "salaboy");
        ProcessInstance processInstance = ksession.startProcess("support.process", params);
        this.assertProcessInstanceActive(processInstance.getId());
        this.assertProcessVarExists(processInstance, new String[]{"customer"});
        List tasksAssignedToSalaboy = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Create Support"});
        SupportProcessTest.assertEquals((long)1L, (long)tasksAssignedToSalaboy.size());
        SupportProcessTest.assertEquals((Object)"Create Support", (Object)((TaskSummary)tasksAssignedToSalaboy.get(0)).getName());
        TaskSummary createSupportTask = (TaskSummary)tasksAssignedToSalaboy.get(0);
        taskService.start(createSupportTask.getId().longValue(), "salaboy");
        Map taskContent = ((InternalTaskService)taskService).getTaskContent(createSupportTask.getId().longValue());
        SupportProcessTest.assertEquals((Object)"salaboy", taskContent.get("input_customer"));
        HashMap<String, String> output = new HashMap<String, String>();
        output.put("output_customer", "salaboy/redhat");
        taskService.complete(createSupportTask.getId().longValue(), "salaboy", output);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Resolve Support"});
        tasksAssignedToSalaboy = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        SupportProcessTest.assertEquals((long)1L, (long)tasksAssignedToSalaboy.size());
        SupportProcessTest.assertEquals((Object)"Resolve Support", (Object)((TaskSummary)tasksAssignedToSalaboy.get(0)).getName());
        TaskSummary resolveSupportTask = (TaskSummary)tasksAssignedToSalaboy.get(0);
        taskService.start(resolveSupportTask.getId().longValue(), "salaboy");
        taskService.complete(resolveSupportTask.getId().longValue(), "salaboy", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Notify Customer"});
        tasksAssignedToSalaboy = taskService.getTasksAssignedAsPotentialOwner("salaboy", "en-UK");
        SupportProcessTest.assertEquals((long)1L, (long)tasksAssignedToSalaboy.size());
        SupportProcessTest.assertEquals((Object)"Notify Customer", (Object)((TaskSummary)tasksAssignedToSalaboy.get(0)).getName());
        TaskSummary notifySupportTask = (TaskSummary)tasksAssignedToSalaboy.get(0);
        taskService.start(notifySupportTask.getId().longValue(), "salaboy");
        output = new HashMap();
        output.put("output_solution", "solved today");
        taskService.complete(notifySupportTask.getId().longValue(), "salaboy", output);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }
}

