/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManagerFactory;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.CountDownProcessEventListener;
import org.jbpm.test.wih.FirstErrorWorkItemHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.event.process.DefaultProcessEventListener;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.ProcessInstanceLog;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;

public class AsyncThreadContinuationTest
extends JbpmTestCase {
    private static Object LOCK_ATC = new Object();
    private static Object LOCK_IT = new Object();
    private static final String PROCESS_ATC = "org.jbpm.test.functional.async.AsyncThreadContinuation";
    private static final String PROCESS_IT = "org.jbpm.test.functional.event.IntermediateTimerErrorRetry";
    private static final String BPMN_ATC = "org/jbpm/test/functional/async/AsyncThreadContinuation.bpmn2";
    private static final String BPMN_IT = "org/jbpm/test/functional/event/IntermediateTimerErrorRetry.bpmn2";
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.init();
        this.addEnvironmentEntry("ExecutorService", this.executorService);
        this.addWorkItemHandler("SyncError", (WorkItemHandler)new FirstErrorWorkItemHandler());
        this.addProcessEventListener((ProcessEventListener)new DefaultProcessEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void afterProcessCompleted(ProcessCompletedEvent event) {
                System.out.println(event.getProcessInstance().getProcessId());
                if (event.getProcessInstance().getProcessId().equals(AsyncThreadContinuationTest.PROCESS_ATC)) {
                    Object object = LOCK_ATC;
                    synchronized (object) {
                        LOCK_ATC.notifyAll();
                    }
                }
                if (event.getProcessInstance().getProcessId().equals(AsyncThreadContinuationTest.PROCESS_IT)) {
                    Object object = LOCK_IT;
                    synchronized (object) {
                        LOCK_IT.notifyAll();
                    }
                }
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    @Test
    public void testCorrectProcessStateAfterException() {
        KieSession ksession = this.createKSession(BPMN_ATC);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", "Ivo");
        ProcessInstance pi = ksession.startProcess(PROCESS_ATC, params);
        List vars = this.getLogService().findVariableInstances(pi.getId(), "message");
        ArrayList<String> varValues = new ArrayList<String>();
        for (VariableInstanceLog v : vars) {
            varValues.add(v.getValue());
        }
        ((AbstractListAssert)Assertions.assertThat(varValues).contains((Object[])new String[]{"Hello Ivo"})).doesNotContain((Object[])new String[]{"Hello Ivo asynchronously"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testRepeatFailingSyncTask() {
        KieSession ksession = this.createKSession(BPMN_ATC);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("message", "Ivo");
        ProcessInstance pi = ksession.startProcess(PROCESS_ATC, params);
        Object object = LOCK_ATC;
        synchronized (object) {
            try {
                LOCK_ATC.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ksession.getProcessInstance(pi.getId());
        List vars = this.getLogService().findVariableInstances(pi.getId(), "message");
        ArrayList<String> varValues = new ArrayList<String>();
        for (VariableInstanceLog v : vars) {
            varValues.add(v.getValue());
        }
        Assertions.assertThat(varValues).contains((Object[])new String[]{"Hello Ivo asynchronously"});
    }

    @Test(timeout=10000L)
    public void testRepeatIntermediateTimerAfterException() {
        CountDownProcessEventListener countDownListener = new CountDownProcessEventListener("MySignal", 1, true);
        KieSession ksession = this.createKSession(BPMN_IT);
        ksession.addEventListener((ProcessEventListener)countDownListener);
        ProcessInstance pi = ksession.startProcess(PROCESS_IT);
        long pid = pi.getId();
        countDownListener.waitTillCompleted();
        pi = ksession.getProcessInstance(pid);
        Assertions.assertThat((Object)pi).isNotNull();
        ksession.abortProcessInstance(pid);
        pi = ksession.getProcessInstance(pid);
        Assertions.assertThat((Object)pi).isNull();
        ProcessInstanceLog log = this.getLogService().findProcessInstance(pid);
        Assertions.assertThat((Integer)log.getStatus()).isEqualTo(3);
    }
}

