/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.internal.command.CommandFactory;
import qa.tools.ikeeper.annotation.BZ;

public class RuleTaskTest
extends JbpmTestCase {
    private static final String RULE_TASK = "org/jbpm/test/functional/task/RuleTask.bpmn";
    private static final String RULE_TASK_ID = "org.jbpm.test.functional.task.RuleTask";
    private static final String RULE_TASK_DRL = "org/jbpm/test/functional/task/RuleTask.drl";
    private static final String RULE_TASK_2 = "org/jbpm/test/functional/task/RuleTask2.bpmn2";
    private static final String RULE_TASK_2_ID = "org.jbpm.test.functional.task.RuleTask2";
    private static final String RULE_TASK_2_DRL = "org/jbpm/test/functional/task/RuleTask2.drl";

    public RuleTaskTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testRuleTask() {
        String[] expected;
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(RULE_TASK, ResourceType.BPMN2);
        res.put(RULE_TASK_DRL, ResourceType.DRL);
        KieSession kieSession = this.createKSession(res);
        ArrayList executedRules = new ArrayList();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newSetGlobal((String)"executed", executedRules));
        commands.add(CommandFactory.newStartProcess((String)RULE_TASK_ID));
        commands.add(CommandFactory.newFireAllRules());
        IterableProcessEventListener listener = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)listener);
        kieSession.execute((Command)CommandFactory.newBatchExecution(commands));
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"rules");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        RuleTaskTest.assertEquals((long)3L, (long)executedRules.size());
        for (String expectedRuleName : expected = new String[]{"firstRule", "secondRule", "thirdRule"}) {
            RuleTaskTest.assertTrue((boolean)executedRules.contains(expectedRuleName));
        }
    }

    @Test(timeout=30000L)
    public void testRuleTaskInsertFact() {
        String[] expected;
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(RULE_TASK, ResourceType.BPMN2);
        res.put(RULE_TASK_DRL, ResourceType.DRL);
        KieSession kieSession = this.createKSession(res);
        ArrayList executedRules = new ArrayList();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(CommandFactory.newSetGlobal((String)"executed", executedRules));
        commands.add(CommandFactory.newInsert((Object)6));
        commands.add(CommandFactory.newStartProcess((String)RULE_TASK_ID));
        commands.add(CommandFactory.newFireAllRules());
        IterableProcessEventListener listener = new IterableProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)listener);
        kieSession.execute((Command)CommandFactory.newBatchExecution(commands));
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"start");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"rules");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)listener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)listener, (String)RULE_TASK_ID);
        RuleTaskTest.assertEquals((long)4L, (long)executedRules.size());
        for (String expectedRuleName : expected = new String[]{"firstRule", "secondRule", "thirdRule", "fifthRule"}) {
            RuleTaskTest.assertTrue((boolean)executedRules.contains(expectedRuleName));
        }
    }

    @BZ(value={"1044504"})
    @Test(timeout=30000L)
    public void testRuleTask2() {
        HashMap<String, ResourceType> res = new HashMap<String, ResourceType>();
        res.put(RULE_TASK_2, ResourceType.BPMN2);
        res.put(RULE_TASK_2_DRL, ResourceType.DRL);
        KieSession ksession = this.createKSession(res);
        ksession.getEnvironment().set("org.jbpm.rule.task.waitstate", (Object)true);
        ProcessInstance pi = ksession.startProcess(RULE_TASK_2_ID, null);
        RuleTaskTest.assertNotNull((Object)pi);
        RuleTaskTest.assertEquals((long)1L, (long)pi.getState());
        ksession.fireAllRules();
        WorkflowProcessInstance wpi = (WorkflowProcessInstance)pi;
        List executeRuleList = (List)wpi.getVariable("results");
        RuleTaskTest.assertNotNull((Object)executeRuleList);
        for (String s : executeRuleList) {
            System.out.println(s);
        }
        RuleTaskTest.assertEquals((long)2L, (long)executeRuleList.size());
        pi = ksession.startProcess(RULE_TASK_2_ID, null);
        RuleTaskTest.assertNotNull((Object)pi);
        RuleTaskTest.assertEquals((long)1L, (long)pi.getState());
        ksession.fireAllRules();
        wpi = (WorkflowProcessInstance)pi;
        executeRuleList = (List)wpi.getVariable("results");
        RuleTaskTest.assertNotNull((Object)executeRuleList);
        for (String s : executeRuleList) {
            System.out.println(s);
        }
        RuleTaskTest.assertEquals((long)2L, (long)executeRuleList.size());
    }

    @Override
    public KieSession createKSession(Map<String, ResourceType> res) {
        this.createRuntimeManager(res);
        return this.getRuntimeEngine().getKieSession();
    }
}

