/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.correlation;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.KieInternalServices;
import org.kie.internal.process.CorrelationAwareProcessRuntime;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationKeyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStartProcessWithCorrelationKeyTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStartProcessWithCorrelationKeyTest.class);
    private CorrelationKeyFactory factory = KieInternalServices.Factory.get().newCorrelationKeyFactory();

    public AbstractStartProcessWithCorrelationKeyTest(boolean persistence) {
        super(true, persistence);
    }

    @Test
    public void testCreateAndStartProcessWithBusinessKey() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/correlation/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).createProcessInstance("com.sample.bpmn.hello", this.getCorrelationKey(), null);
        ksession.startProcessInstance(processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessWithBusinessKey() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/correlation/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getCorrelationKey(), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessWithBusinessKeyFailOnDuplicatedBusinessKey() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/correlation/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getCorrelationKey(), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        try {
            ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getCorrelationKey(), null);
            AbstractStartProcessWithCorrelationKeyTest.fail((String)"Cannot have duplicated business key running at the same time");
        }
        catch (Exception exception) {
            // empty catch block
        }
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}" + task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessesWithSameBusinessKeyNotInParallel() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/correlation/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getCorrelationKey(), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
        processInstance = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getCorrelationKey(), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessWithMultiValuedBusinessKey() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/correlation/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getMultiValuedCorrelationKey(), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getMultiValuedCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessWithInvalidBusinessKey() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/correlation/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getMultiValuedCorrelationKey(), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceNotFound = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNull((Object)processInstanceNotFound);
        ProcessInstance processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getMultiValuedCorrelationKey());
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testProcessesWithSameBusinessKeyInParallel() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/correlation/humantask.bpmn"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ProcessInstance processInstance = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getMultiValuedCorrelationKey("first", "second"), null);
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Start", "Task 1"});
        List list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        TaskSummary task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceCopy = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getMultiValuedCorrelationKey("first", "second"));
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance.getId(), (long)processInstanceCopy.getId());
        ProcessInstance processInstance2 = ((CorrelationAwareProcessRuntime)ksession).startProcess("com.sample.bpmn.hello", this.getMultiValuedCorrelationKey("third", "fourth"), null);
        this.assertProcessInstanceActive(processInstance2.getId(), ksession);
        this.assertNodeTriggered(processInstance2.getId(), new String[]{"Start", "Task 1"});
        list = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("John is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "john");
        taskService.complete(task.getId().longValue(), "john", null);
        this.assertNodeTriggered(processInstance2.getId(), new String[]{"Task 2"});
        ProcessInstance processInstanceCopy2 = ((CorrelationAwareProcessRuntime)ksession).getProcessInstance(this.getMultiValuedCorrelationKey("third", "fourth"));
        AbstractStartProcessWithCorrelationKeyTest.assertNotNull((Object)processInstanceCopy2);
        AbstractStartProcessWithCorrelationKeyTest.assertEquals((long)processInstance2.getId(), (long)processInstanceCopy2.getId());
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance2.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance2.getId(), ksession);
        list = taskService.getTasksAssignedAsPotentialOwner("mary", "en-UK");
        task = (TaskSummary)list.get(0);
        logger.info("Mary is executing task {}", (Object)task.getName());
        taskService.start(task.getId().longValue(), "mary");
        taskService.complete(task.getId().longValue(), "mary", null);
        this.assertNodeTriggered(processInstance.getId(), new String[]{"End"});
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    private CorrelationKey getCorrelationKey() {
        return this.factory.newCorrelationKey("mybusinesskey");
    }

    private CorrelationKey getMultiValuedCorrelationKey() {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("customerid");
        properties.add("orderid");
        return this.factory.newCorrelationKey(properties);
    }

    private CorrelationKey getMultiValuedCorrelationKey(String ... props) {
        ArrayList<String> properties = new ArrayList<String>();
        for (String prop : props) {
            properties.add(prop);
        }
        return this.factory.newCorrelationKey(properties);
    }
}

