/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.workitem;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.drools.core.process.instance.WorkItemManager;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.functional.workitem.ExceptionWorkItemHandler;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.EmptyContext;

public class RetrySyncWorkItemByJPATest
extends JbpmTestCase {
    private static final String RETRY_WORKITEM_JPA_PROCESS_ID = "org.jbpm.test.retryWorkitem-jpa";

    public RetrySyncWorkItemByJPATest() {
        super(true, true);
    }

    @Test
    public void workItemRecoveryTestByJPA() {
        this.manager = this.createRuntimeManager(new String[]{"org/jbpm/test/functional/workitem/retry-workitem-jpa.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine(EmptyContext.get());
        KieSession kieSession = runtimeEngine.getKieSession();
        WorkItemManager workItemManager = (WorkItemManager)kieSession.getWorkItemManager();
        workItemManager.registerWorkItemHandler("ExceptionWorkitem", (WorkItemHandler)new ExceptionWorkItemHandler());
        ProcessInstance pi = kieSession.startProcess(RETRY_WORKITEM_JPA_PROCESS_ID);
        TaskService taskService = runtimeEngine.getTaskService();
        this.assertProcessInstanceActive(pi.getId());
        this.assertNodeTriggered(pi.getId(), new String[]{"lockingNode"});
        this.assertNodeActive(pi.getId(), kieSession, new String[]{"lockingNode"});
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        RetrySyncWorkItemByJPATest.assertEquals((long)1L, (long)tasks.size());
        TaskSummary taskSummary = (TaskSummary)tasks.get(0);
        taskService.start(taskSummary.getId().longValue(), "john");
        taskService.complete(taskSummary.getId().longValue(), "john", null);
        WorkflowProcessInstance processInstance = (WorkflowProcessInstance)kieSession.getProcessInstance(pi.getId());
        Collection nis = processInstance.getNodeInstances();
        this.retryWorkItem(workItemManager, nis);
        this.assertProcessInstanceCompleted(processInstance.getId());
    }

    private void retryWorkItem(WorkItemManager workItemManager, Collection<NodeInstance> nis) {
        for (NodeInstance di : nis) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("exception", "no");
            workItemManager.retryWorkItem(Long.valueOf(di.getId()), map);
        }
    }
}

