/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.event;

import java.util.Arrays;
import java.util.Collection;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;

@RunWith(value=Parameterized.class)
public class SignalProcessTest
extends JbpmTestCase {
    @Parameterized.Parameters(name="Persistence={1} - data source={0}")
    public static Collection<Object[]> parameters() {
        Object[][] locking = new Object[][]{{true, true}, {false, false}};
        return Arrays.asList(locking);
    }

    public SignalProcessTest(boolean dataSource, boolean persistence) {
        super(dataSource, persistence);
    }

    @Test
    public void testDoubleSignalProcess() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/event/sample_doublesignal.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.signal");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.signalEvent("Signal1", (Object)"", processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.signalEvent("Signal1", (Object)"", processInstance.getId());
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }

    @Test
    public void testDoubleMessageProcess() {
        this.createRuntimeManager(new String[]{"org/jbpm/test/functional/event/sample_doublemessagesignal.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        ProcessInstance processInstance = ksession.startProcess("com.sample.msg");
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.signalEvent("Message-TestMessage", (Object)"", processInstance.getId());
        this.assertProcessInstanceActive(processInstance.getId(), ksession);
        ksession.signalEvent("Message-TestMessage", (Object)"", processInstance.getId());
        this.assertProcessInstanceNotActive(processInstance.getId(), ksession);
    }
}

