/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.jbpm.test.tools.IterableListenerAssert;
import org.junit.Test;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.runtime.KieSession;

public class ReusableSubProcessTest
extends JbpmTestCase {
    private static final String CALL_ACTIVITY_PARENT = "org/jbpm/test/functional/subprocess/ReusableSubProcess-parent.bpmn";
    private static final String CALL_ACTIVITY_PARENT_ID = "org.jbpm.test.functional.subprocess.ReusableSubProcess-parent";
    private static final String CALL_ACTIVITY_CHILD = "org/jbpm/test/functional/subprocess/ReusableSubProcess-child.bpmn";
    private static final String CALL_ACTIVITY_CHILD_ID = "org.jbpm.test.functional.subprocess.ReusableSubProcess-child";

    public ReusableSubProcessTest() {
        super(false);
    }

    @Test(timeout=30000L)
    public void testCallActivity() {
        KieSession ksession = this.createKSession(CALL_ACTIVITY_CHILD, CALL_ACTIVITY_PARENT);
        IterableProcessEventListener eventListener = new IterableProcessEventListener();
        ksession.addEventListener((ProcessEventListener)eventListener);
        ksession.execute(ReusableSubProcessTest.getCommands().newStartProcess(CALL_ACTIVITY_PARENT_ID));
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_PARENT_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"script");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"var", null, (Object)1);
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"script");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"reusable");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"inSubVar", null, (Object)1);
        IterableListenerAssert.assertProcessStarted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_CHILD_ID);
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"rs-start");
        IterableListenerAssert.assertTriggered((IterableProcessEventListener)eventListener, (String)"rs-script");
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"outSubVar", null, (Object)"one");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"rs-script");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"rs-end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_CHILD_ID);
        IterableListenerAssert.assertChangedVariable((IterableProcessEventListener)eventListener, (String)"var", (Object)1, (Object)"one");
        IterableListenerAssert.assertLeft((IterableProcessEventListener)eventListener, (String)"reusable");
        IterableListenerAssert.assertNextNode((IterableProcessEventListener)eventListener, (String)"end");
        IterableListenerAssert.assertProcessCompleted((IterableProcessEventListener)eventListener, (String)CALL_ACTIVITY_PARENT_ID);
    }
}

