/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.tools;

import org.assertj.core.api.Assertions;
import org.jbpm.test.listener.IterableProcessEventListener;
import org.kie.api.event.process.ProcessVariableChangedEvent;

public class IterableListenerAssert {
    public static void assertNextNode(IterableProcessEventListener it, String nodeName) {
        IterableListenerAssert.assertTriggered(it, nodeName);
        IterableListenerAssert.assertLeft(it, nodeName);
    }

    public static void assertProcessStarted(IterableProcessEventListener it, String processId) {
        IterableProcessEventListener.TrackedEvent event = IterableListenerAssert.getEvent(it);
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"beforeProcessStarted");
        IterableProcessEventListener.CachedProcessStartedEvent orig = (IterableProcessEventListener.CachedProcessStartedEvent)event.getEvent();
        Assertions.assertThat((String)orig.getProcessId()).isEqualTo((Object)processId);
    }

    public static void assertProcessCompleted(IterableProcessEventListener it, String processId) {
        IterableProcessEventListener.TrackedEvent event = IterableListenerAssert.getEvent(it);
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"beforeProcessCompleted");
        IterableProcessEventListener.CachedProcessCompletedEvent orig = (IterableProcessEventListener.CachedProcessCompletedEvent)event.getEvent();
        Assertions.assertThat((String)orig.getProcessId()).isEqualTo((Object)processId);
    }

    public static void assertTriggered(IterableProcessEventListener it, String nodeName) {
        IterableProcessEventListener.TrackedEvent event = IterableListenerAssert.getEvent(it);
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"beforeNodeTriggered");
        IterableProcessEventListener.CachedProcessNodeTriggeredEvent orig = (IterableProcessEventListener.CachedProcessNodeTriggeredEvent)event.getEvent();
        Assertions.assertThat((String)orig.getNodeName()).isEqualTo((Object)nodeName);
    }

    public static void assertLeft(IterableProcessEventListener it, String nodeName) {
        IterableProcessEventListener.TrackedEvent event = IterableListenerAssert.getEvent(it);
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"beforeNodeLeft");
        IterableProcessEventListener.CachedProcessNodeLeftEvent orig = (IterableProcessEventListener.CachedProcessNodeLeftEvent)event.getEvent();
        Assertions.assertThat((String)orig.getNodeName()).isEqualTo((Object)nodeName);
    }

    public static void assertChangedVariable(IterableProcessEventListener it, String name, Object oldValue, Object newValue) {
        IterableProcessEventListener.TrackedEvent event = IterableListenerAssert.getEvent(it);
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"beforeVariableChanged");
        ProcessVariableChangedEvent orig = (ProcessVariableChangedEvent)event.getEvent();
        Assertions.assertThat((String)orig.getVariableId()).isEqualTo((Object)name);
        IterableListenerAssert.assertChangedVariableValues(orig, oldValue, newValue);
        event = it.next();
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"afterVariableChanged");
        orig = (ProcessVariableChangedEvent)event.getEvent();
        Assertions.assertThat((String)orig.getVariableId()).isEqualTo((Object)name);
        IterableListenerAssert.assertChangedVariableValues(orig, oldValue, newValue);
    }

    private static void assertChangedVariableValues(ProcessVariableChangedEvent event, Object oldValue, Object newValue) {
        if (oldValue == null) {
            Assertions.assertThat((Object)event.getOldValue()).isNull();
        } else {
            Assertions.assertThat((Object)event.getOldValue()).isEqualTo(oldValue);
        }
        if (newValue == null) {
            Assertions.assertThat((Object)event.getNewValue()).isNull();
        } else {
            Assertions.assertThat((Object)event.getNewValue()).isEqualTo(newValue);
        }
    }

    public static void assertChangedMultipleInstancesVariable(IterableProcessEventListener it, String name, Object oldValue, Object newValue) {
        IterableProcessEventListener.TrackedEvent event = IterableListenerAssert.getEvent(it);
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"beforeVariableChanged");
        ProcessVariableChangedEvent orig = (ProcessVariableChangedEvent)event.getEvent();
        Assertions.assertThat((boolean)orig.getVariableId().endsWith(":" + name)).isTrue();
        IterableListenerAssert.assertChangedVariableValues(orig, oldValue, newValue);
        event = it.next();
        Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"afterVariableChanged");
        orig = (ProcessVariableChangedEvent)event.getEvent();
        Assertions.assertThat((boolean)orig.getVariableId().endsWith(":" + name)).isTrue();
        IterableListenerAssert.assertChangedVariableValues(orig, oldValue, newValue);
    }

    public static void assertMultipleVariablesChanged(IterableProcessEventListener it, String ... variables) {
        for (int i = 0; i < variables.length; ++i) {
            IterableProcessEventListener.TrackedEvent event = IterableListenerAssert.getEvent(it);
            Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"beforeVariableChanged");
            ProcessVariableChangedEvent orig = (ProcessVariableChangedEvent)event.getEvent();
            boolean found = false;
            String name = null;
            for (String str : variables) {
                found = orig.getVariableId().equals(str);
                name = str;
                if (found) break;
            }
            Assertions.assertThat((boolean)found).isTrue();
            event = it.next();
            Assertions.assertThat((String)event.getMethod()).isEqualTo((Object)"afterVariableChanged");
            orig = (ProcessVariableChangedEvent)event.getEvent();
            Assertions.assertThat((boolean)orig.getVariableId().equals(name)).isTrue();
        }
    }

    private static IterableProcessEventListener.TrackedEvent getEvent(IterableProcessEventListener it) {
        Assertions.assertThat((boolean)it.hasNext()).isTrue();
        return it.next();
    }
}

