/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.listener;

import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeEvent;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugProcessEventListener
implements ProcessEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugProcessEventListener.class);

    public void afterNodeLeft(ProcessNodeLeftEvent event) {
        LOGGER.debug(this.formatNodeMessage("afterNodeLeft", (ProcessNodeEvent)event));
    }

    public void afterNodeTriggered(ProcessNodeTriggeredEvent event) {
        LOGGER.debug(this.formatNodeMessage("afterNodeTriggered", (ProcessNodeEvent)event));
    }

    public void afterProcessCompleted(ProcessCompletedEvent event) {
        LOGGER.debug(this.formatProcessMessage("afterProcessCompleted", (ProcessEvent)event));
    }

    public void afterProcessStarted(ProcessStartedEvent event) {
        LOGGER.debug(this.formatProcessMessage("afterProcessStarted", (ProcessEvent)event));
    }

    public void afterVariableChanged(ProcessVariableChangedEvent event) {
        LOGGER.debug(this.formatVariableChangedMessage("afterVariableChanged", event));
    }

    public void beforeNodeLeft(ProcessNodeLeftEvent event) {
        LOGGER.debug(this.formatNodeMessage("beforeNodeLeft", (ProcessNodeEvent)event));
    }

    public void beforeNodeTriggered(ProcessNodeTriggeredEvent event) {
        LOGGER.debug(this.formatNodeMessage("beforeNodeTriggered", (ProcessNodeEvent)event));
    }

    public void beforeProcessCompleted(ProcessCompletedEvent event) {
        LOGGER.debug(this.formatProcessMessage("beforeProcessCompleted", (ProcessEvent)event));
    }

    public void beforeProcessStarted(ProcessStartedEvent event) {
        LOGGER.debug(this.formatProcessMessage("beforeProcessStarted", (ProcessEvent)event));
    }

    public void beforeVariableChanged(ProcessVariableChangedEvent event) {
        LOGGER.debug(this.formatVariableChangedMessage("beforeVariableChanged", event));
    }

    private String formatNodeMessage(String when, ProcessNodeEvent event) {
        NodeInstance ni = event.getNodeInstance();
        return String.format("<%s> name:%s, id:%s", when, ni.getNodeName(), ni.getNodeId());
    }

    private String formatProcessMessage(String when, ProcessEvent event) {
        ProcessInstance pi = event.getProcessInstance();
        return String.format("<%s> name:%s, id:%s, state:%s", when, pi.getProcessName(), pi.getProcessId(), pi.getState());
    }

    private String formatVariableChangedMessage(String when, ProcessVariableChangedEvent event) {
        return String.format("<%s> id:%s, old:%s, new:%s", when, event.getVariableId(), event.getOldValue(), event.getNewValue());
    }
}

