/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.timer;

import java.util.HashMap;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTimerPersistenceTest
extends JbpmTestCase {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryTimerPersistenceTest.class);
    private static final String PROCESS_FILE_NAME = "org/jbpm/test/functional/timer/boundaryTimerProcess.bpmn";
    private static final String PROCESS_NAME = "BoundaryTimerEventProcess";
    private static final String WORK_ITEM_HANLDER_TASK = "Human Task";
    private static final String TIMER_FIRED_PROP = "timerFired";
    private static final String TIMER_FIRED_TIME_PROP = "afterTimerTime";

    public InMemoryTimerPersistenceTest() {
        super(true, false);
    }

    @Before
    public void setup() {
        System.clearProperty(TIMER_FIRED_PROP);
        System.clearProperty(TIMER_FIRED_TIME_PROP);
    }

    @Test
    public void boundaryEventTimerAndCompleteHumanTaskWithoutPersistence() throws InterruptedException {
        this.createRuntimeManager(new String[]{PROCESS_FILE_NAME});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine();
        KieSession ksession = runtimeEngine.getKieSession();
        HumanTaskMockHandler humanTaskMockHandler = new HumanTaskMockHandler();
        ProcessInstance process = this.registerHTHandlerAndStartProcess(ksession, humanTaskMockHandler);
        this.sleepAndVerifyTimerRuns(process.getState());
        this.completeWork(ksession, humanTaskMockHandler);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[2]), (long)2L, (long)processState);
    }

    private ProcessInstance registerHTHandlerAndStartProcess(KieSession ksession, HumanTaskMockHandler humanTaskMockHandler) {
        ksession.getWorkItemManager().registerWorkItemHandler(WORK_ITEM_HANLDER_TASK, (WorkItemHandler)humanTaskMockHandler);
        ProcessInstance process = ksession.startProcess(PROCESS_NAME);
        long processId = process.getId();
        Assert.assertTrue((String)"process id not saved", (processId > 0L ? 1 : 0) != 0);
        int processState = process.getState();
        Assert.assertEquals((String)("Expected process state to be " + processStateName[1] + " not " + processStateName[processState]), (long)1L, (long)processState);
        return process;
    }

    private void completeWork(KieSession ksession, HumanTaskMockHandler humanTaskMockHandler) {
        Assert.assertTrue((String)"The work item task handler does not have a work item!", (humanTaskMockHandler.workItem != null ? 1 : 0) != 0);
        long workItemId = humanTaskMockHandler.workItem.getId();
        Assert.assertTrue((String)"work item id not saved", (workItemId > 0L ? 1 : 0) != 0);
        HashMap results = new HashMap();
        try {
            ksession.getWorkItemManager().completeWorkItem(workItemId, results);
        }
        catch (Exception e) {
            logger.warn("Work item could not be completed!");
            e.printStackTrace();
            Assert.fail((String)(e.getClass().getSimpleName() + " thrown when completing work item: " + e.getMessage()));
        }
    }

    private void sleepAndVerifyTimerRuns(int processState) throws InterruptedException {
        if (processState == 1) {
            int sleep = 2000;
            logger.debug("Sleeping {} seconds", (Object)(sleep / 1000));
            Thread.sleep(sleep);
            logger.debug("Awake!");
        }
        long afterSleepTime = System.currentTimeMillis();
        Assert.assertTrue((String)"The timer has not fired!", (boolean)this.timerHasFired());
        Assert.assertTrue((String)"The timer did not fire on time!", (afterSleepTime > this.timerFiredTime() ? 1 : 0) != 0);
        int timerFiredCount = this.timerFiredCount();
        Assert.assertTrue((String)("The timer only fired " + timerFiredCount + " times."), (timerFiredCount >= 1 ? 1 : 0) != 0);
    }

    private boolean timerHasFired() {
        String hasFired = System.getProperty(TIMER_FIRED_PROP);
        return hasFired != null;
    }

    private int timerFiredCount() {
        String timerFiredCount = System.getProperty(TIMER_FIRED_PROP);
        if (timerFiredCount == null) {
            return 0;
        }
        return Integer.parseInt(timerFiredCount);
    }

    private long timerFiredTime() {
        String timerFiredCount = System.getProperty(TIMER_FIRED_TIME_PROP);
        if (timerFiredCount == null) {
            return 0L;
        }
        return Long.parseLong(timerFiredCount);
    }

    private static class HumanTaskMockHandler
    implements org.drools.core.process.instance.WorkItemHandler {
        private WorkItemManager workItemManager;
        private WorkItem workItem;

        private HumanTaskMockHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = workItem;
            this.workItemManager = manager;
            logger.debug("Work completed!");
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItemManager.abortWorkItem(workItem.getId());
            logger.debug("Work aborted.");
        }
    }
}

