/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.log;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.jbpm.services.task.audit.service.TaskJPAAuditService;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.AuditTask;
import org.kie.internal.task.query.AuditTaskDeleteBuilder;
import org.kie.internal.task.query.TaskEventDeleteBuilder;
import org.kie.internal.task.query.TaskVariableDeleteBuilder;
import qa.tools.ikeeper.annotation.BZ;

public class TaskLogCleanTest
extends JbpmTestCase {
    private static final String HUMAN_TASK = "org/jbpm/test/functional/common/HumanTask.bpmn2";
    private static final String HUMAN_TASK_ID = "org.jbpm.test.functional.common.HumanTask";
    private static final String INPUT_ASSOCIATION = "org/jbpm/test/functional/log/TaskLogClean-inputAssociation.bpmn2";
    private static final String INPUT_ASSOCIATION_ID = "org.jbpm.test.functional.log.TaskLogClean-inputAssociation";
    private static final String HUMAN_TASK_MULTIACTORS = "org/jbpm/test/functional/common/HumanTaskWithMultipleActors.bpmn2";
    private static final String HUMAN_TASK_MULTIACTORS_ID = "org.jbpm.test.functional.common.HumanTaskWithMultipleActors";
    private KieSession kieSession;
    private List<ProcessInstance> processInstanceList;
    private TaskJPAAuditService taskAuditService;

    public void setUp() throws Exception {
        super.setUp();
        this.taskAuditService = new TaskJPAAuditService(this.getEmf());
        this.taskAuditService.clear();
    }

    public void tearDown() throws Exception {
        try {
            this.taskAuditService.clear();
            this.taskAuditService.dispose();
            this.abortProcess(this.kieSession, this.processInstanceList);
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testDeleteLogsByProcessId() {
        this.kieSession = this.createKSession(HUMAN_TASK);
        this.processInstanceList = this.startProcess(this.kieSession, HUMAN_TASK_ID, 2);
        this.abortProcess(this.kieSession, this.processInstanceList);
        int deletedLogs = ((AuditTaskDeleteBuilder)this.taskAuditService.auditTaskDelete().processId(new String[]{HUMAN_TASK_ID})).build().execute();
        Assertions.assertThat((int)deletedLogs).isEqualTo(2);
        Assertions.assertThat(this.getAllAuditTaskLogs()).hasSize(0);
    }

    @Test
    public void testDeleteLogsByProcessName() {
        this.kieSession = this.createKSession(HUMAN_TASK);
        this.processInstanceList = this.startProcess(this.kieSession, HUMAN_TASK_ID, 3);
        this.abortProcess(this.kieSession, this.processInstanceList);
        int resultCount = ((AuditTaskDeleteBuilder)this.taskAuditService.auditTaskDelete().processInstanceId(new long[]{this.processInstanceList.get(0).getId(), this.processInstanceList.get(1).getId()})).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(2);
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        List taskIdList = taskService.getTasksByProcessInstanceId(this.processInstanceList.get(2).getId());
        Assertions.assertThat((List)taskIdList).hasSize(1);
    }

    @Test
    @BZ(value={"1188702"})
    public void testDeleteLogsByDate() {
        this.kieSession = this.createKSession(HUMAN_TASK);
        this.processInstanceList = this.startProcess(this.kieSession, HUMAN_TASK_ID, 4);
        this.abortProcess(this.kieSession, this.processInstanceList);
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        HashSet<Date> startDates = new HashSet<Date>();
        for (int i = this.processInstanceList.size() - 1; i > 0; --i) {
            List taskIdList = taskService.getTasksByProcessInstanceId(this.processInstanceList.get(i).getId());
            Assertions.assertThat((List)taskIdList).hasSize(1);
            Task task = taskService.getTaskById(((Long)taskIdList.get(0)).longValue());
            Assertions.assertThat((Object)task).isNotNull();
            startDates.add(task.getTaskData().getCreatedOn());
        }
        int resultCount = startDates.stream().map(s -> ((AuditTaskDeleteBuilder)this.taskAuditService.auditTaskDelete().date(new Date[]{s})).build().execute()).collect(Collectors.summingInt(Integer::intValue));
        Assertions.assertThat((int)resultCount).isEqualTo(3);
    }

    @Test
    @BZ(value={"1193017"})
    public void testDeleteLogsByDateRange() throws InterruptedException {
        this.processInstanceList = new ArrayList<ProcessInstance>();
        this.kieSession = this.createKSession(HUMAN_TASK, INPUT_ASSOCIATION);
        Date date1 = new Date();
        this.processInstanceList.addAll(this.startProcess(this.kieSession, INPUT_ASSOCIATION_ID, 2));
        this.processInstanceList.addAll(this.startProcess(this.kieSession, HUMAN_TASK_ID, 1));
        Date date2 = new Date();
        Thread.sleep(1000L);
        this.processInstanceList.addAll(this.startProcess(this.kieSession, INPUT_ASSOCIATION_ID, 1));
        this.processInstanceList.addAll(this.startProcess(this.kieSession, HUMAN_TASK_ID, 1));
        this.abortProcess(this.kieSession, this.processInstanceList);
        int resultCount = this.deleteAuditTaskInstanceLogs(date1, date2);
        Assertions.assertThat((int)resultCount).isEqualTo(3);
        Assertions.assertThat(this.getAllAuditTaskLogs()).hasSize(2);
    }

    private void testDeleteLogsByDateRange(Date startDate, Date endDate, boolean remove) {
        this.processInstanceList = new ArrayList<ProcessInstance>();
        this.kieSession = this.createKSession(HUMAN_TASK);
        this.processInstanceList.addAll(this.startProcess(this.kieSession, HUMAN_TASK_ID, 5));
        this.abortProcess(this.kieSession, this.processInstanceList);
        int resultCount = this.deleteAuditTaskInstanceLogs(startDate, endDate);
        Assertions.assertThat((int)resultCount).isEqualTo(remove ? 5 : 0);
        Assertions.assertThat(this.getAllAuditTaskLogs()).hasSize(remove ? 0 : 5);
    }

    @Test
    public void testDeleteLogsByDateRangeEndingYesterday() {
        this.testDeleteLogsByDateRange(this.getYesterday(), this.getYesterday(), false);
    }

    @Test
    public void testDeleteLogsByDateRangeIncludingToday() {
        this.testDeleteLogsByDateRange(this.getYesterday(), this.getTomorrow(), true);
    }

    @Test
    public void testDeleteLogsByDateRangeStartingTomorrow() {
        this.testDeleteLogsByDateRange(this.getTomorrow(), this.getTomorrow(), false);
    }

    @Test
    public void testDeleteTaskEventByDate() {
        this.kieSession = this.createKSession(HUMAN_TASK_MULTIACTORS);
        Date startDate = new Date();
        this.processInstanceList = this.startProcess(this.kieSession, HUMAN_TASK_MULTIACTORS_ID, 1);
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        Task task = taskService.getTaskById(((Long)taskService.getTasksByProcessInstanceId(this.processInstanceList.get(0).getId()).get(0)).longValue());
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((Comparable)task.getTaskData().getStatus()).isEqualTo((Object)Status.Ready);
        taskService.claim(task.getId().longValue(), "krisv");
        taskService.start(task.getId().longValue(), "krisv");
        taskService.complete(task.getId().longValue(), "krisv", null);
        this.processInstanceList.clear();
        int resultCount = ((TaskEventDeleteBuilder)((TaskEventDeleteBuilder)this.taskAuditService.taskEventInstanceLogDelete().dateRangeStart(startDate)).dateRangeEnd(new Date())).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(4);
    }

    @Test
    public void testDeleteTaskVariablesByDateActiveProcess() {
        this.kieSession = this.createKSession(INPUT_ASSOCIATION);
        Date startDate = new Date();
        this.processInstanceList = this.startProcess(this.kieSession, INPUT_ASSOCIATION_ID, 1);
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        Task task = taskService.getTaskById(((Long)taskService.getTasksByProcessInstanceId(this.processInstanceList.get(0).getId()).get(0)).longValue());
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((Comparable)task.getTaskData().getStatus()).isEqualTo((Object)Status.Reserved);
        List vars = this.taskAuditService.taskVariableQuery().build().getResultList();
        Assertions.assertThat((List)vars).hasSize(1);
        int resultCount = ((TaskVariableDeleteBuilder)((TaskVariableDeleteBuilder)this.taskAuditService.taskVariableInstanceLogDelete().dateRangeStart(startDate)).dateRangeEnd(new Date())).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(0);
        vars = this.taskAuditService.taskVariableQuery().build().getResultList();
        Assertions.assertThat((List)vars).hasSize(1);
    }

    @Test
    public void testDeleteTaskVariablesByDate() {
        this.kieSession = this.createKSession(HUMAN_TASK_MULTIACTORS);
        Date startDate = new Date();
        this.processInstanceList = this.startProcess(this.kieSession, HUMAN_TASK_MULTIACTORS_ID, 1);
        TaskService taskService = this.getRuntimeEngine().getTaskService();
        Task task = taskService.getTaskById(((Long)taskService.getTasksByProcessInstanceId(this.processInstanceList.get(0).getId()).get(0)).longValue());
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((Comparable)task.getTaskData().getStatus()).isEqualTo((Object)Status.Ready);
        List vars = this.taskAuditService.taskVariableQuery().build().getResultList();
        Assertions.assertThat((List)vars).hasSize(0);
        taskService.claim(task.getId().longValue(), "krisv");
        taskService.start(task.getId().longValue(), "krisv");
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("test", "testvalue");
        taskService.complete(task.getId().longValue(), "krisv", results);
        vars = this.taskAuditService.taskVariableQuery().build().getResultList();
        Assertions.assertThat((List)vars).hasSize(1);
        this.processInstanceList.clear();
        int resultCount = ((TaskVariableDeleteBuilder)((TaskVariableDeleteBuilder)this.taskAuditService.taskVariableInstanceLogDelete().dateRangeStart(startDate)).dateRangeEnd(new Date())).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(1);
    }

    @Test
    @BZ(value={"1192912"})
    public void testClearLogs() {
        this.kieSession = this.createKSession(HUMAN_TASK);
        this.processInstanceList = this.startProcess(this.kieSession, HUMAN_TASK_ID, 2);
        this.taskAuditService.clear();
        Assertions.assertThat(this.getAllAuditTaskLogs()).hasSize(this.processInstanceList.size());
        this.abortProcess(this.kieSession, this.processInstanceList);
        this.taskAuditService.clear();
        Assertions.assertThat(this.getAllAuditTaskLogs()).hasSize(0);
    }

    private int deleteAuditTaskInstanceLogs(Date startDate, Date endDate) {
        return ((AuditTaskDeleteBuilder)((AuditTaskDeleteBuilder)this.taskAuditService.auditTaskDelete().dateRangeStart(startDate)).dateRangeEnd(endDate)).build().execute();
    }

    private List<AuditTask> getAllAuditTaskLogs() {
        return this.taskAuditService.auditTaskQuery().build().getResultList();
    }

    private Date getTomorrow() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, 1);
        return c.getTime();
    }

    private Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        return c.getTime();
    }

    private void abortProcess(KieSession kieSession, List<ProcessInstance> processInstanceList) {
        for (ProcessInstance processInstance : processInstanceList) {
            this.abortProcess(kieSession, processInstance.getId());
        }
    }

    private void abortProcess(KieSession kieSession, long pid) {
        ProcessInstance processInstance = kieSession.getProcessInstance(pid);
        if (processInstance != null && processInstance.getState() == 1) {
            kieSession.abortProcessInstance(pid);
        }
    }

    private List<ProcessInstance> startProcess(KieSession kieSession, String processId, int count) {
        ArrayList<ProcessInstance> piList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance pi = kieSession.startProcess(processId);
            if (pi == null) continue;
            piList.add(pi);
        }
        return piList;
    }
}

