/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.task;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.appformer.maven.support.AFReleaseId;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jbpm.kie.test.util.AbstractKieServicesBaseTest;
import org.jbpm.process.instance.event.DefaultSignalManagerFactory;
import org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeEnvironment;
import org.kie.api.runtime.manager.RuntimeEnvironmentBuilder;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.manager.RuntimeManagerFactory;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.context.EmptyContext;
import org.kie.scanner.KieMavenRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTaskWithDependencyTest
extends AbstractKieServicesBaseTest {
    private static final String SCRIPT_TASK_JAVA = "/org/jbpm/test/functional/task/ScriptTaskJavaWithDep.bpmn";
    private static final String SCRIPT_TASK_JAVA_ID = "org.jbpm.test.functional.task.ScriptTaskJavaWithDep";
    private static final String SCRIPT_TASK_MVEL = "/org/jbpm/test/functional/task/ScriptTaskMvelWithDep.bpmn";
    private static final String SCRIPT_TASK_MVEL_ID = "org.jbpm.test.functional.task.ScriptTaskMvelWithDep";
    private static final String GROUP_ID = "org.example";
    private static final String ARTIFACT_ID = "script-dep";
    private static final String VERSION = "1.0.0";
    protected static final Logger logger = LoggerFactory.getLogger(ScriptTaskWithDependencyTest.class);
    private static RuntimeManager runtimeManager;
    private static RuntimeEngine runtimeEngine;
    private static KieSession kieSession;

    @Before
    public void prepare() throws Exception {
        KieServices ks = KieServices.Factory.get();
        ReleaseId releaseIdDep = ks.newReleaseId(GROUP_ID, "dependency-data", VERSION);
        String classStr = "package defaultPackage;\npublic class TestPojo {\n    public void say() {\n        System.out.println(\"Hey I'm \" + this);\n    }\n}";
        HashMap<String, String> resourcesDep = new HashMap<String, String>();
        resourcesDep.put("src/main/java/defaultPackage/TestPojo.java", classStr);
        InternalKieModule kJarDep = this.createKieJar(ks, releaseIdDep, new ArrayList(), resourcesDep, new ReleaseId[0]);
        this.installKjar(releaseIdDep, kJarDep);
        ReleaseId releaseId = ks.newReleaseId(GROUP_ID, ARTIFACT_ID, VERSION);
        HashMap<String, String> resources = new HashMap<String, String>();
        String process1String = IOUtils.toString((InputStream)ScriptTaskWithDependencyTest.class.getResourceAsStream(SCRIPT_TASK_JAVA), (String)"UTF-8");
        resources.put("src/main/resources/org/jbpm/test/functional/task/ScriptTaskJavaWithDep.bpmn", process1String);
        String process2String = IOUtils.toString((InputStream)ScriptTaskWithDependencyTest.class.getResourceAsStream(SCRIPT_TASK_MVEL), (String)"UTF-8");
        resources.put("src/main/resources/org/jbpm/test/functional/task/ScriptTaskMvelWithDep.bpmn", process2String);
        InternalKieModule kJar1 = this.createKieJar(ks, releaseId, new ArrayList(), resources, new ReleaseId[]{releaseIdDep});
        this.installKjar(releaseId, kJar1);
        KieContainer kieContainer = ks.newKieContainer(releaseId);
        RuntimeEnvironment environment = RuntimeEnvironmentBuilder.Factory.get().newEmptyBuilder().knowledgeBase(kieContainer.getKieBase()).addConfiguration("drools.processSignalManagerFactory", DefaultSignalManagerFactory.class.getName()).addConfiguration("drools.processInstanceManagerFactory", DefaultProcessInstanceManagerFactory.class.getName()).get();
        runtimeManager = RuntimeManagerFactory.Factory.get().newSingletonRuntimeManager(environment);
        runtimeEngine = runtimeManager.getRuntimeEngine(EmptyContext.get());
        kieSession = runtimeEngine.getKieSession();
    }

    @After
    public void cleanup() {
        runtimeManager.disposeRuntimeEngine(runtimeEngine);
        runtimeManager.close();
        ScriptTaskWithDependencyTest.cleanupSingletonSessionId();
    }

    @Test(timeout=30000L)
    public void testScriptTaskJava() throws Exception {
        this.testScriptTask(SCRIPT_TASK_JAVA_ID);
    }

    @Test(timeout=30000L)
    public void testScriptTaskMvel() throws Exception {
        this.testScriptTask(SCRIPT_TASK_MVEL_ID);
    }

    private void testScriptTask(String processId) throws Exception {
        ProcessInstance pi = kieSession.startProcess(processId);
        Assert.assertEquals((long)2L, (long)pi.getState());
    }

    protected void installKjar(ReleaseId releaseId, InternalKieModule kJar1) {
        File pom = new File("target/kmodule", "pom.xml");
        pom.getParentFile().mkdir();
        try {
            FileOutputStream fs = new FileOutputStream(pom);
            fs.write(this.getPom(releaseId, new ReleaseId[0]).getBytes());
            fs.close();
        }
        catch (Exception fs) {
            // empty catch block
        }
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)releaseId, kJar1, pom);
    }
}

