/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.async;

import javax.persistence.EntityManagerFactory;
import org.jbpm.executor.ExecutorServiceFactory;
import org.jbpm.kie.services.impl.admin.commands.TriggerNodeCommand;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.listener.TrackingProcessEventListener;
import org.jbpm.test.tools.TrackingListenerAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.executor.ExecutorService;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;

public class AsyncAdHocSubprocessTest
extends JbpmTestCase {
    private static final String ADHOC_ASYNC = "org/jbpm/test/functional/async/AsyncAdHocSubprocess.bpmn2";
    private static final String ADHOC_ASYNC_ID = "org.jbpm.test.functional.async.AsyncAdHocSubprocess";
    private ExecutorService executorService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executorService = ExecutorServiceFactory.newExecutorService((EntityManagerFactory)this.getEmf());
        this.executorService.setInterval(1);
        this.executorService.init();
        this.addEnvironmentEntry("ExecutorService", this.executorService);
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.executorService.destroy();
    }

    @Test
    public void testAdHocSubAsyncProcessAuto() throws Exception {
        long WAIT_ACTION = 10000L;
        KieSession kieSession = this.createKSession(ADHOC_ASYNC);
        TrackingProcessEventListener eventListener = new TrackingProcessEventListener();
        kieSession.addEventListener((ProcessEventListener)eventListener);
        ProcessInstance pi = kieSession.startProcess(ADHOC_ASYNC_ID);
        long id = pi.getId();
        eventListener.waitForProcessToStart(10000L);
        TrackingListenerAssert.assertProcessStarted((TrackingProcessEventListener)eventListener, (String)ADHOC_ASYNC_ID);
        eventListener.waitForNodeToBeLeft("start", 10000L);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"start");
        kieSession.execute((Command)new TriggerNodeCommand(id, 3L));
        eventListener.waitForNodeToBeLeft("script1", 10000L);
        TrackingListenerAssert.assertTriggeredAndLeft((TrackingProcessEventListener)eventListener, (String)"script1");
        kieSession.abortProcessInstance(id);
        eventListener.waitForProcessToAbort(10000L);
        this.assertProcessInstanceAborted(id);
    }
}

