/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.regression.event;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.AuditService;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.api.runtime.process.WorkItemManager;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Task;
import qa.tools.ikeeper.annotation.BZ;

public class TimerEventTest
extends JbpmTestCase {
    private static final String EXCEPTION_AFTER_TIMER = "org/jbpm/test/regression/event/TimerEvent-exceptionAfter.bpmn2";
    private static final String EXCEPTION_AFTER_TIMER_ID = "org.jbpm.test.regression.event.TimerEvent-exceptionAfter";
    private static final String START_TIMER_CYCLE = "org/jbpm/test/regression/event/TimerEvent-startTimerCycle.bpmn2";
    private static final String START_TIMER_CYCLE_ID = "org.jbpm.test.regression.event.TimerEvent-startTimerCycle";
    private static final String CANCELLED_TIMER = "org/jbpm/test/regression/event/TimerEvent-cancelledTimer.bpmn";
    private static final String CANCELLED_TIMER_ID = "org.jbpm.test.regression.event.TimerEvent-cancelledTimer";
    private static final String TIMER_AND_GATEWAY = "org/jbpm/test/regression/event/TimerEvent-timerAndGateway.bpmn";
    private static final String TIMER_AND_GATEWAY_ID = "org.jbpm.test.regression.event.TimerEvent-timerAndGateway";
    public static final String BOUNDARY_MULTIPLE_INSTANCES = "org/jbpm/test/regression/event/TimerEvent-boundaryMultipleInstances.bpmn2";
    public static final String BOUNDARY_MULTIPLE_INSTANCES_ID = "org.jbpm.test.regression.event.TimerEvent-boundaryMultipleInstances";

    @Test
    @BZ(value={"958390", "1167738"})
    public void testRuntimeExceptionAfterTimer() throws InterruptedException {
        KieSession ksession = this.createKSession(EXCEPTION_AFTER_TIMER);
        ProcessInstance pi = ksession.startProcess(EXCEPTION_AFTER_TIMER_ID);
        Thread.sleep(3000L);
        this.assertProcessInstanceActive(pi.getId());
        ksession.abortProcessInstance(pi.getId());
        this.assertProcessInstanceAborted(pi.getId());
    }

    @Test
    @BZ(value={"1104563"})
    public void testStartTimerCycle() throws InterruptedException {
        this.createKSession(START_TIMER_CYCLE);
        AuditService auditService = this.getLogService();
        Thread.sleep(5000L);
        Assertions.assertThat((List)auditService.findProcessInstances()).hasSize(1);
        Thread.sleep(5000L);
        Assertions.assertThat((List)auditService.findProcessInstances()).hasSize(2);
        Thread.sleep(5000L);
        Assertions.assertThat((List)auditService.findProcessInstances()).hasSize(3);
    }

    @Test
    @BZ(value={"1148304"})
    public void testCancelledTimerNotScheduled() {
        for (int i = 0; i < 5; ++i) {
            this.createRuntimeManager(JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE, null, new String[]{CANCELLED_TIMER});
            KieSession ksession = this.getRuntimeEngine().getKieSession();
            TaskService taskService = this.getRuntimeEngine().getTaskService();
            HashMap params = new HashMap();
            ProcessInstance pi = ksession.startProcess(CANCELLED_TIMER_ID, params);
            System.out.println("A process instance started : pid = " + pi.getId());
            List list = taskService.getTasksByProcessInstanceId(pi.getId());
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                long taskId = (Long)iterator.next();
                Task task = taskService.getTaskById(taskId);
                System.out.println("taskId = " + task.getId() + ", status = " + task.getTaskData().getStatus());
            }
            Date before = new Date();
            this.disposeRuntimeManager();
            Date after = new Date();
            long seconds = (after.getTime() - before.getTime()) / 1000L;
            ((AbstractLongAssert)Assertions.assertThat((long)seconds).as("Cancelled timer has been scheduled", new Object[0])).isLessThan(5L);
        }
    }

    @Test
    @BZ(value={"1036761"})
    public void testTimerAndGateway() throws Exception {
        KieSession ksession = this.createKSession(TIMER_AND_GATEWAY);
        int sessionId = ksession.getId();
        TestAsyncWorkItemHandler handler1 = new TestAsyncWorkItemHandler();
        TestAsyncWorkItemHandler handler2 = new TestAsyncWorkItemHandler();
        ksession.getWorkItemManager().registerWorkItemHandler("task1", (WorkItemHandler)handler1);
        ksession.getWorkItemManager().registerWorkItemHandler("task2", (WorkItemHandler)handler2);
        ProcessInstance instance = ksession.createProcessInstance(TIMER_AND_GATEWAY_ID, new HashMap());
        ksession.startProcessInstance(instance.getId());
        WorkItem workItem1 = handler1.getWorkItem();
        Assertions.assertThat((Object)workItem1).isNotNull();
        Assertions.assertThat((Object)handler1.getWorkItem()).isNull();
        ksession.getWorkItemManager().completeWorkItem(workItem1.getId(), null);
        ksession = this.restoreKSession(TIMER_AND_GATEWAY);
        ksession.getWorkItemManager().registerWorkItemHandler("task1", (WorkItemHandler)handler1);
        ksession.getWorkItemManager().registerWorkItemHandler("task2", (WorkItemHandler)handler2);
        for (int i = 0; i < 7; ++i) {
            Thread.sleep(1000L);
        }
        WorkItem workItem2 = handler2.getWorkItem();
        Assertions.assertThat((Object)workItem2).isNotNull();
        Assertions.assertThat((Object)handler1.getWorkItem()).isNull();
    }

    @Test
    @BZ(value={"1213209"})
    public void testBoundaryTimerInMultipleInstancesSubprocess() throws InterruptedException {
        KieSession ksession = this.createKSession(BOUNDARY_MULTIPLE_INSTANCES);
        ksession.setGlobal("counter", (Object)0);
        HashSet<Integer> runList = new HashSet<Integer>();
        runList.add(1);
        runList.add(2);
        runList.add(3);
        HashMap<String, HashSet<Integer>> parameters = new HashMap<String, HashSet<Integer>>();
        parameters.put("runList", runList);
        ksession.startProcess(BOUNDARY_MULTIPLE_INSTANCES_ID, parameters);
        Thread.sleep(1000L);
        Integer counter = (Integer)ksession.getGlobal("counter");
        Assertions.assertThat((Integer)counter).isEqualTo(3);
    }

    private static class TestAsyncWorkItemHandler
    implements WorkItemHandler {
        private WorkItem workItem;
        private int activations = 0;

        private TestAsyncWorkItemHandler() {
        }

        public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
            System.out.println("Starting call to handler " + workItem.getName());
            this.workItem = workItem;
            ++this.activations;
        }

        public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            this.workItem = null;
        }

        public WorkItem getWorkItem() {
            WorkItem result = this.workItem;
            this.workItem = null;
            return result;
        }

        public int getActivations() {
            return this.activations;
        }
    }
}

