/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.log;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.test.JbpmTestCase;
import org.jbpm.test.domain.Person;
import org.junit.Ignore;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.audit.VariableInstanceLog;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogDeleteBuilder;
import org.kie.internal.runtime.manager.audit.query.VariableInstanceLogQueryBuilder;

public class VariableInstanceLogCleanTest
extends JbpmTestCase {
    private static final String DATA_OBJECT = "org/jbpm/test/functional/log/VariableInstanceLogClean-dataObject.bpmn";
    private static final String DATA_OBJECT_ID = "org.jbpm.test.functional.log.VariableInstanceLogClean-dataObject";
    private KieSession kieSession;
    private List<ProcessInstance> processInstanceList = new ArrayList<ProcessInstance>();
    private JPAAuditLogService auditService;

    public void setUp() throws Exception {
        super.setUp();
        this.auditService = new JPAAuditLogService(this.getEmf());
        this.auditService.clear();
    }

    public void tearDown() throws Exception {
        try {
            this.abortProcess(this.kieSession, this.processInstanceList);
            this.auditService.clear();
            this.auditService.dispose();
        }
        finally {
            super.tearDown();
        }
    }

    @Ignore
    @Test
    public void deleteDataObjectLogsByDateRange() throws InterruptedException {
        this.kieSession = this.createKSession(DATA_OBJECT);
        Person person = new Person("Marge");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("person", person);
        Date start = new Date();
        this.processInstanceList.addAll(this.startProcess(this.kieSession, DATA_OBJECT_ID, paramMap, 1));
        Date mid = new Date();
        this.processInstanceList.addAll(this.startProcess(this.kieSession, DATA_OBJECT_ID, paramMap, 2));
        Date end = new Date();
        this.processInstanceList.addAll(this.startProcess(this.kieSession, DATA_OBJECT_ID, paramMap, 1));
        int resultCount = ((VariableInstanceLogDeleteBuilder)((VariableInstanceLogDeleteBuilder)this.auditService.variableInstanceLogDelete().dateRangeStart(start)).dateRangeEnd(mid)).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(1);
        List variableList = this.auditService.variableInstanceLogQuery().dateRangeStart(mid).dateRangeEnd(end).variableId(new String[]{"person"}).build().getResultList();
        Assertions.assertThat((int)variableList.size()).isEqualTo(2);
        Assertions.assertThat((Date)((VariableInstanceLog)variableList.get(0)).getDate()).isBefore(mid);
        Assertions.assertThat((Date)((VariableInstanceLog)variableList.get(1)).getDate()).isAfter(end);
    }

    @Ignore
    @Test
    public void deleteDataObjectLogsByDate() {
        this.kieSession = this.createKSession(DATA_OBJECT);
        Person person = new Person("Homer");
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("person", person);
        this.processInstanceList = this.startProcess(this.kieSession, DATA_OBJECT_ID, paramMap, 3);
        Assertions.assertThat(this.processInstanceList).hasSize(3);
        List variableList = ((VariableInstanceLogQueryBuilder)this.auditService.variableInstanceLogQuery().processInstanceId(new long[]{this.processInstanceList.get(1).getId(), this.processInstanceList.get(2).getId()})).variableId(new String[]{"person"}).build().getResultList();
        Assertions.assertThat((List)variableList).hasSize(2);
        int resultCount = ((VariableInstanceLogDeleteBuilder)this.auditService.variableInstanceLogDelete().date(new Date[]{((VariableInstanceLog)variableList.get(0)).getDate(), ((VariableInstanceLog)variableList.get(1)).getDate()})).build().execute();
        Assertions.assertThat((int)resultCount).isEqualTo(2);
        variableList = this.auditService.variableInstanceLogQuery().variableId(new String[]{"person"}).build().getResultList();
        Assertions.assertThat((List)variableList).hasSize(1);
        Assertions.assertThat((String)((VariableInstanceLog)variableList.get(0)).getValue()).contains(new CharSequence[]{"name='Homer'"});
    }

    private void abortProcess(KieSession kieSession, List<ProcessInstance> processInstanceList) {
        for (ProcessInstance processInstance : processInstanceList) {
            this.abortProcess(kieSession, processInstance.getId());
        }
    }

    private void abortProcess(KieSession kieSession, long pid) {
        ProcessInstance processInstance = kieSession.getProcessInstance(pid);
        if (processInstance != null && processInstance.getState() == 1) {
            kieSession.abortProcessInstance(pid);
        }
    }

    private List<ProcessInstance> startProcess(KieSession kieSession, String processId, int count) {
        ArrayList<ProcessInstance> piList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance pi = kieSession.startProcess(processId);
            if (pi == null) continue;
            piList.add(pi);
        }
        return piList;
    }

    public List<ProcessInstance> startProcess(KieSession kieSession, String processId, Map<String, Object> parameters, int count) {
        ArrayList<ProcessInstance> processInstanceList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance processInstance = kieSession.startProcess(processId, parameters);
            processInstanceList.add(processInstance);
        }
        return processInstanceList;
    }
}

