/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.subprocess;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.jbpm.test.JbpmJUnitBaseTestCase;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.Context;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.runtime.process.WorkflowProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.TaskSummary;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

@RunWith(value=Parameterized.class)
public class CallActivityWithReadOnlyProcessInstanceTest
extends JbpmTestCase {
    private final JbpmJUnitBaseTestCase.Strategy strategy;

    @Parameterized.Parameters(name="Strategy : {0}")
    public static Collection<Object[]> parameters() {
        Object[][] locking = new Object[][]{{JbpmJUnitBaseTestCase.Strategy.SINGLETON}, {JbpmJUnitBaseTestCase.Strategy.PROCESS_INSTANCE}, {JbpmJUnitBaseTestCase.Strategy.REQUEST}};
        return Arrays.asList(locking);
    }

    public CallActivityWithReadOnlyProcessInstanceTest(JbpmJUnitBaseTestCase.Strategy runtimeStrategy) {
        super(true, true);
        this.strategy = runtimeStrategy;
    }

    @Test
    public void testCallActivityWithReadOnlyProcessInstance() throws Exception {
        InitialContext context = new InitialContext();
        UserTransaction ut = (UserTransaction)context.lookup("java:comp/UserTransaction");
        RuntimeManager manager = this.createRuntimeManager(this.strategy, null, new String[]{"org/jbpm/test/functional/subprocess/CallActivityWithVar-Main.bpmn2", "org/jbpm/test/functional/subprocess/CallActivityWithVar-Sub.bpmn2"});
        RuntimeEngine runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get());
        KieSession ksession = runtimeEngine.getKieSession();
        TaskService taskService = runtimeEngine.getTaskService();
        ut.begin();
        ProcessInstance processInstance = ksession.startProcess("helloMain");
        long parentProcessInstanceId = processInstance.getId();
        ut.commit();
        manager.disposeRuntimeEngine(runtimeEngine);
        runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)parentProcessInstanceId));
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        ut.begin();
        WorkflowProcessInstance readOnlyParentProcessInstance = (WorkflowProcessInstance)ksession.getProcessInstance(parentProcessInstanceId, true);
        Assert.assertEquals((Object)0, (Object)readOnlyParentProcessInstance.getVariable("Var1"));
        List tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        Long taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        ut.commit();
        manager.disposeRuntimeEngine(runtimeEngine);
        runtimeEngine = this.getRuntimeEngine((Context)ProcessInstanceIdContext.get((Long)processInstance.getId()));
        ksession = runtimeEngine.getKieSession();
        taskService = runtimeEngine.getTaskService();
        ut.begin();
        readOnlyParentProcessInstance = (WorkflowProcessInstance)ksession.getProcessInstance(parentProcessInstanceId, true);
        Assert.assertEquals((Object)1, (Object)readOnlyParentProcessInstance.getVariable("Var1"));
        tasks = taskService.getTasksAssignedAsPotentialOwner("john", "en-UK");
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1L, (long)tasks.size());
        taskId = ((TaskSummary)tasks.get(0)).getId();
        taskService.start(taskId.longValue(), "john");
        taskService.complete(taskId.longValue(), "john", null);
        ut.commit();
        ut.begin();
        this.assertProcessInstanceCompleted(parentProcessInstanceId);
        ut.commit();
        manager.disposeRuntimeEngine(runtimeEngine);
        this.activeEngines.clear();
    }
}

