/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.test.functional.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.jbpm.process.audit.JPAAuditLogService;
import org.jbpm.process.audit.NodeInstanceLog;
import org.jbpm.process.audit.ProcessInstanceLog;
import org.jbpm.process.audit.VariableInstanceLog;
import org.jbpm.services.task.audit.impl.model.TaskEventImpl;
import org.jbpm.test.JbpmTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.task.api.InternalTaskService;

public class ProcessInstanceLogArchiveTest
extends JbpmTestCase {
    private static final String HELLO_WORLD_PROCESS = "org/jbpm/test/functional/common/HumanTask.bpmn2";
    private static final String HELLO_WORLD_PROCESS_ID = "org.jbpm.test.functional.common.HumanTask";
    private JPAAuditLogService auditService;

    public void setUp() throws Exception {
        super.setUp();
        this.auditService = new JPAAuditLogService(this.getEmf());
        this.auditService.clear();
    }

    public void tearDown() throws Exception {
        try {
            this.auditService.clear();
            this.auditService.dispose();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void checkEndDateArchived() {
        KieSession kieSession = this.createKSession(HELLO_WORLD_PROCESS);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("var", params);
        this.startProcess(kieSession, HELLO_WORLD_PROCESS_ID, 2, params);
        InternalTaskService taskService = (InternalTaskService)this.getRuntimeEngine().getTaskService();
        taskService.getTasksAssignedAsPotentialOwnerByStatusByGroup("john", null, null).forEach(e -> {
            taskService.start(e.getId().longValue(), "john");
            taskService.complete(e.getId().longValue(), "john", Collections.emptyMap());
        });
        EntityManager em = this.getEmf().createEntityManager();
        List pLogs = em.createQuery("SELECT o FROM ProcessInstanceLog o", ProcessInstanceLog.class).getResultList();
        Assert.assertTrue((!pLogs.isEmpty() ? 1 : 0) != 0);
        for (ProcessInstanceLog log : pLogs) {
            Assert.assertNotNull((Object)log.getEnd());
        }
        List ids = pLogs.stream().map(ProcessInstanceLog::getId).collect(Collectors.toList());
        List nLogs = em.createQuery("SELECT o FROM NodeInstanceLog o", NodeInstanceLog.class).getResultList();
        Assert.assertTrue((!nLogs.isEmpty() ? 1 : 0) != 0);
        for (Object log : nLogs) {
            Assert.assertNotNull((Object)log.getEnd());
        }
        List vLogs = em.createQuery("SELECT o FROM VariableInstanceLog o", VariableInstanceLog.class).getResultList();
        Assert.assertTrue((!vLogs.isEmpty() ? 1 : 0) != 0);
        for (VariableInstanceLog log : vLogs) {
            Assert.assertNotNull((Object)log.getEnd());
        }
        List tLogs = em.createQuery("SELECT o FROM TaskEventImpl o WHERE o.processInstanceId IN (:var)", TaskEventImpl.class).setParameter("var", ids).getResultList();
        Assert.assertTrue((!tLogs.isEmpty() ? 1 : 0) != 0);
        for (TaskEventImpl log : tLogs) {
            Assert.assertNotNull((Object)log.getEnd());
        }
        em.close();
    }

    private List<ProcessInstance> startProcess(KieSession kieSession, String processId, int count, Map<String, Object> var) {
        ArrayList<ProcessInstance> piList = new ArrayList<ProcessInstance>();
        for (int i = 0; i < count; ++i) {
            ProcessInstance pi = kieSession.startProcess(processId, var);
            if (pi == null) continue;
            piList.add(pi);
        }
        return piList;
    }
}

